/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Declarator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.ICElementWrapper;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.Parameter;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.parser.util.DeclSpecifier;
import org.eclipse.cdt.internal.core.parser.util.Name;

public class SimpleDeclarationWrapper
extends DeclSpecifier
implements DeclSpecifier.Container,
ICElementWrapper {
    private CElement element = null;
    private CElement parent = null;
    int kind;
    private Name name = null;
    private boolean functionDefinition = false;
    List declarators = new LinkedList();
    DeclSpecifier declSpec = null;
    public static final int v_public = 0;
    public static final int v_protected = 1;
    public static final int v_private = 2;
    private int currentVisibility;

    public SimpleDeclarationWrapper(CElement item) {
        this.element = item;
    }

    public SimpleDeclarationWrapper() {
    }

    public CElement getElement() {
        return this.element;
    }

    public void setElement(CElement item) {
        this.element = item;
    }

    public CElement getParent() {
        return this.parent;
    }

    public void setParent(CElement parent) {
        this.parent = parent;
    }

    public void createElements() {
        List declaratorList = this.getDeclarators();
        Declarator[] declarators = declaratorList.toArray(new Declarator[declaratorList.size()]);
        CElement parentElement = this.getParent();
        int i = 0;
        while (i < declarators.length) {
            Declarator currentDeclarator = declarators[i];
            CElement declaration = null;
            List clause = currentDeclarator.getParameterDeclarationClause();
            if (clause == null && !this.isTypedef()) {
                if (currentDeclarator.getName() == null) {
                    return;
                }
                if (parentElement instanceof IStructure) {
                    declaration = this.createField(parentElement, currentDeclarator.getName().toString());
                } else if (parentElement instanceof ITranslationUnit) {
                    declaration = this.isExtern() ? this.createVariableDeclaration(parentElement, currentDeclarator.getName().toString()) : this.createVariable(parentElement, currentDeclarator.getName().toString());
                }
            } else if (!this.isTypedef()) {
                Parameter[] parameters = clause.toArray(new Parameter[clause.size()]);
                if (parentElement instanceof IStructure) {
                    declaration = this.createMethodDeclaration(parentElement, currentDeclarator.getName().toString(), parameters);
                } else if (parentElement instanceof ITranslationUnit) {
                    declaration = this.isFunctionDefinition() ? this.createFunction(parentElement, currentDeclarator.getName().toString(), parameters) : this.createFunctionDeclaration(parentElement, currentDeclarator.getName().toString(), parameters);
                }
            }
            declaration.setIdPos(currentDeclarator.getName().getStartOffset(), currentDeclarator.getName().toString().length());
            declaration.setPos(currentDeclarator.getName().getStartOffset(), currentDeclarator.getName().toString().length());
            parentElement.addChild(declaration);
            ++i;
        }
    }

    public void addDeclarator(Object in) {
        this.declarators.add(in);
    }

    public List getDeclarators() {
        return this.declarators;
    }

    public DeclSpecifier getDeclSpecifier() {
        if (this.declSpec == null) {
            this.declSpec = new DeclSpecifier();
        }
        return this.declSpec;
    }

    public void setDeclSpecifier(DeclSpecifier in) {
        this.declSpec = in;
    }

    public void removeDeclarator(Object declarator) {
        this.declarators.remove(declarator);
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public boolean isFunctionDefinition() {
        return this.functionDefinition;
    }

    public void setFunctionDefinition(boolean functionDefinition) {
        this.functionDefinition = functionDefinition;
    }

    public int getCurrentVisibility() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(int currentVisibility) {
        this.currentVisibility = currentVisibility;
    }

    private CElement createField(CElement parent, String name) {
        Field newElement = new Field(parent, name);
        newElement.setTypeName(this.getTypeName());
        newElement.setIsConst(this.isConst());
        newElement.setIsMutable(this.isMutable());
        newElement.setVisibility(this.getCurrentVisibility());
        return newElement;
    }

    private CElement createVariable(CElement parent, String name) {
        Variable newElement = new Variable(parent, name);
        newElement.setTypeName(this.getTypeName());
        return newElement;
    }

    private CElement createVariableDeclaration(CElement parent, String name) {
        VariableDeclaration newElement = new VariableDeclaration(parent, name);
        newElement.setTypeName(this.getTypeName());
        return newElement;
    }

    private CElement createMethodDeclaration(CElement parent, String name, Parameter[] parameters) {
        String[] parameterTypes = new String[parameters.length];
        int j = 0;
        while (j < parameters.length) {
            Parameter param = parameters[j];
            parameterTypes[j] = new String(param.getTypeName());
            ++j;
        }
        MethodDeclaration newElement = new MethodDeclaration(parent, name);
        newElement.setParameterTypes(parameterTypes);
        newElement.setReturnType(this.getTypeName());
        newElement.setVisibility(this.getCurrentVisibility());
        return newElement;
    }

    private CElement createMethod(CElement parent, String name, Parameter[] parameters) {
        String[] parameterTypes = new String[parameters.length];
        int j = 0;
        while (j < parameters.length) {
            Parameter param = parameters[j];
            parameterTypes[j] = new String(param.getTypeName());
            ++j;
        }
        Method newElement = new Method(parent, name);
        newElement.setParameterTypes(parameterTypes);
        newElement.setReturnType(this.getTypeName());
        newElement.setVisibility(this.getCurrentVisibility());
        return newElement;
    }

    private CElement createFunctionDeclaration(CElement parent, String name, Parameter[] parameters) {
        FunctionDeclaration newElement = new FunctionDeclaration(parent, name);
        newElement.setReturnType(this.getTypeName());
        return newElement;
    }

    private CElement createFunction(CElement parent, String name, Parameter[] parameters) {
        Function newElement = new Function(parent, name);
        newElement.setReturnType(this.getTypeName());
        return newElement;
    }
}

