/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class SourceManipulation
extends Parent
implements ISourceManipulation,
ISourceReference {
    public SourceManipulation(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getCModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        ICElement[] elements = new ICElement[]{this};
        this.getCModel().delete(elements, force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getCModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        if (name == null) {
            throw new IllegalArgumentException("element.nullName");
        }
        ICElement[] elements = new ICElement[]{this};
        ICElement[] dests = new ICElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getCModel().rename(elements, dests, renamings, force, monitor);
    }

    public ITranslationUnit getTranslationUnit() {
        return this.getSourceManipulationInfo().getTranslationUnit();
    }

    public IResource getCorrespondingResource() throws CModelException {
        return null;
    }

    public IOpenable getOpenableParent() {
        ICElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            current = current.getParent();
        }
        return null;
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    public IResource getUnderlyingResource() throws CModelException {
        return this.getParent().getUnderlyingResource();
    }

    public IResource getResource() {
        return null;
    }

    protected CElementInfo createElementInfo() {
        return new SourceManipulationInfo(this);
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        return (SourceManipulationInfo)this.getElementInfo();
    }
}

