/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    IPath location = null;
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement parent, IFile file) {
        super(parent, (IResource)file, 60);
    }

    public TranslationUnit(ICElement parent, IPath path) {
        super(parent, path, 60);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String name, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            ISourceRange range = ((ISourceReference)((Object)celements[i])).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public ICElement getElement(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (name.equals(celements[i].getElementName())) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public IInclude getInclude(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 72 && name.equals(celements[i].getElementName())) {
                return (IInclude)celements[i];
            }
            ++i;
        }
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 72) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62 && name.equals(celements[i].getElementName())) {
                return (IUsing)celements[i];
            }
            ++i;
        }
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IUsing[0]);
    }

    public void setLocation(IPath loc) {
        this.location = loc;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                this.location = file.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    protected IFile getFile() {
        IResource res = this.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected void parse(InputStream in) {
        this.getTranslationUnitInfo().parse(in);
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    protected void buildStructure(OpenableInfo info, IProgressMonitor monitor) throws CModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iter = newElements.keySet().iterator();
        while (iter.hasNext()) {
            ICElement key = (ICElement)iter.next();
            Object value = newElements.get(key);
            CModelManager.getDefault().putInfo(key, value);
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        CModelManager.getDefault().putInfo(this, info);
    }

    public boolean equals(Object o) {
        return super.equals(o) && !((ITranslationUnit)o).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    private void getNewElements(Map newElements, CElement element) {
        CElementInfo info = element.getElementInfo();
        if (info != null && element instanceof IParent) {
            ICElement[] children = info.getChildren();
            int size = children.length;
            int i = 0;
            while (i < size) {
                CElement child = (CElement)children[i];
                this.getNewElements(newElements, child);
                ++i;
            }
        }
        newElements.put(element, info);
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().putInfo(this, info);
        TranslationUnitInfo unitInfo = (TranslationUnitInfo)info;
        this.parse();
        this.getNewElements(newElements, this);
        if (this.isWorkingCopy()) {
            ITranslationUnit original = ((IWorkingCopy)((Object)this)).getOriginalElement();
            unitInfo.fTimestamp = ((IFile)original.getResource()).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (CModelException e) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        CModelManager manager = CModelManager.getDefault();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap<TranslationUnit, WorkingCopy> perFactoryWorkingCopies = (HashMap<TranslationUnit, WorkingCopy>)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap<TranslationUnit, WorkingCopy>();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        workingCopy = (WorkingCopy)this.getWorkingCopy(monitor, factory);
        perFactoryWorkingCopies.put(this, workingCopy);
        return workingCopy;
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        WorkingCopy workingCopy = new WorkingCopy(this.getParent(), this.getFile(), factory);
        workingCopy.open(monitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean isConsistent() throws CModelException {
        return CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws CModelException {
        if (!this.isConsistent()) {
            OpenableInfo info = (OpenableInfo)this.createElementInfo();
            this.buildStructure(info, pm);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        IResource file;
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null && (file = this.getResource()) != null && file.getType() == 1) {
            buffer.setContents(Util.getResourceContentsAsCharArray((IFile)file));
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public void parse() {
        try {
            this.getTranslationUnitInfo().parse(this.getBuffer().getContents());
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }
}

