/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.internal.core.parser.BranchTracker;
import org.eclipse.cdt.internal.core.parser.ExpressionEvaluator;
import org.eclipse.cdt.internal.core.parser.IMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.IScanner;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.MacroDescriptor;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerException;
import org.eclipse.cdt.internal.core.parser.Token;

public class Scanner
implements IScanner {
    private static final int NOCHAR = -1;
    private static final String TEXT = "<text>";
    private static final String START = "<initial reader>";
    private static final String EXPRESSION = "<expression>";
    private static final String PASTING = "<pasting>";
    private static final String BAD_PP = "Invalid preprocessor directive encountered at offset ";
    private static final String DEFINED = "defined";
    private static final String POUND_DEFINE = "#define ";
    private IScannerContext currentContext;
    private Stack contextStack = new Stack();
    private List includePathNames = new ArrayList();
    private List includePaths = new ArrayList();
    private Hashtable definitions = new Hashtable();
    private StringBuffer storageBuffer = null;
    private Set inclusions = new HashSet();
    private int count = 0;
    private static HashMap keywords = new HashMap();
    private static HashMap ppDirectives = new HashMap();
    private Token currentToken = null;
    private boolean passOnToClient = true;
    private BranchTracker branches = new BranchTracker();
    private boolean throwExceptionPPError = true;
    private boolean throwExceptionOnRedefinition = false;
    private boolean throwExceptionOnBadUndefinition = false;
    private boolean throwExceptionOnBadPreprocessorSyntax = true;
    private boolean throwExceptionOnInclusionNotFound = true;
    private boolean throwExceptionOnBadMacroExpansion = true;
    private boolean throwExceptionOnUnboundedString = true;
    private boolean throwExceptionOnEOFWithinMultilineComment = true;
    private boolean throwExceptionOnEOFWithoutBalancedEndifs = true;
    private boolean throwExceptionOnBadCharacterRead = true;
    private boolean quickScan = false;
    private IParserCallback callback;

    public IScanner initialize(Reader reader, String filename) {
        this.init(reader, filename);
        return this;
    }

    protected void init(Reader reader, String filename) {
        this.contextStack.push(new ScannerContext().initialize(new StringReader("\n"), START, 0));
        this.currentContext = filename == null ? new ScannerContext().initialize(reader, TEXT, 1) : new ScannerContext().initialize(reader, filename, 1);
    }

    public Scanner() {
    }

    protected Scanner(Reader reader, String filename, Hashtable defns) {
        this.initialize(reader, filename);
        this.definitions = defns;
    }

    protected void updateContext(Reader reader, String filename, int type) throws ScannerException {
        if (type == 2) {
            if (!this.inclusions.add(filename)) {
                throw new ScannerException("Inclusion " + filename + " already encountered.");
            }
            System.out.println("Handle inclusion - " + filename);
        }
        this.contextStack.push(this.currentContext);
        this.currentContext = new ScannerContext().initialize(reader, filename, type);
    }

    protected boolean rollbackContext() {
        try {
            this.currentContext.getReader().close();
        }
        catch (IOException ie) {
            System.out.println("Error closing reader");
        }
        if (this.currentContext.getKind() == 2) {
            this.inclusions.remove(this.currentContext.getFilename());
            System.out.println("Completed inclusion - " + this.currentContext.getFilename());
        }
        if (this.contextStack.isEmpty()) {
            this.currentContext = null;
            return false;
        }
        this.currentContext = (ScannerContext)this.contextStack.pop();
        return true;
    }

    public void addIncludePath(String includePath) {
        this.includePathNames.add(includePath);
        this.includePaths.add(new File(includePath));
    }

    public void overwriteIncludePath(List newIncludePaths) {
        this.includePathNames = null;
        this.includePaths = null;
        this.includePathNames = new ArrayList();
        this.includePaths = new ArrayList();
        this.includePathNames.addAll(newIncludePaths);
        Iterator i = this.includePathNames.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            this.includePaths.add(new File(path));
        }
    }

    public void addDefinition(String key, IMacroDescriptor macro) {
        this.definitions.put(key, macro);
    }

    public void addDefinition(String key, String value) {
        this.definitions.put(key, value);
    }

    public final Object getDefinition(String key) {
        return this.definitions.get(key);
    }

    public final Object[] getIncludePaths() {
        return this.includePathNames.toArray();
    }

    protected boolean skipOverWhitespace() {
        int c = this.getChar();
        boolean result = false;
        while (c != -1 && (c == 32 || c == 9)) {
            c = this.getChar();
            result = true;
        }
        if (c != -1) {
            this.ungetChar(c);
        }
        return result;
    }

    protected String getRestOfPreprocessorLine() throws ScannerException {
        StringBuffer buffer;
        block7: {
            buffer = new StringBuffer();
            this.skipOverWhitespace();
            int c = this.getChar();
            while (true) {
                if (c != 10 && c != 13 && c != 92 && c != 47 && c != -1) {
                    buffer.append((char)c);
                    c = this.getChar();
                    continue;
                }
                if (c != 47) break;
                int next = this.getChar();
                if (next == 47) {
                    this.skipOverTextUntilNewline();
                    break block7;
                }
                if (next == 42) {
                    if (!this.skipOverMultilineComment()) {
                        c = this.getChar();
                        continue;
                    }
                    break block7;
                }
                buffer.append((char)c);
                c = next;
            }
            if (c != 92) {
                this.ungetChar(c);
            } else {
                c = this.getChar();
            }
        }
        return buffer.toString();
    }

    protected void skipOverTextUntilNewline() {
        while (true) {
            switch (this.getChar()) {
                case -1: 
                case 10: {
                    return;
                }
                case 92: {
                    this.getChar();
                }
            }
        }
    }

    private void setCurrentToken(Token t) {
        if (this.currentToken != null) {
            this.currentToken.setNext(t);
        }
        this.currentToken = t;
    }

    protected void resetStorageBuffer() {
        if (this.storageBuffer != null) {
            this.storageBuffer = null;
        }
    }

    protected Token newToken(int t, String i, IScannerContext c) {
        this.setCurrentToken(new Token(t, i, c));
        return this.currentToken;
    }

    protected Token newToken(int t, String i) {
        this.setCurrentToken(new Token(t, i));
        return this.currentToken;
    }

    protected String getNextIdentifier() {
        StringBuffer buffer = new StringBuffer();
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
            buffer.append((char)c);
            c = this.getChar();
            while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                buffer.append((char)c);
                c = this.getChar();
            }
        }
        this.ungetChar(c);
        return buffer.toString();
    }

    protected void handleInclusion(String fileName, boolean useIncludePaths) throws ScannerException {
        block9: {
            if (useIncludePaths) {
                Iterator iter = this.includePaths.iterator();
                while (iter.hasNext()) {
                    String newPath;
                    File includeFile;
                    File pathFile = (File)iter.next();
                    if (!pathFile.isDirectory() || !(includeFile = new File(newPath = pathFile.getPath() + File.separatorChar + fileName)).exists() || !includeFile.isFile()) continue;
                    try {
                        FileReader inclusionReader = new FileReader(includeFile);
                        this.updateContext(inclusionReader, newPath, 2);
                        return;
                    }
                    catch (FileNotFoundException fnf) {
                        // empty catch block
                    }
                }
            } else {
                String currentFilename = this.currentContext.getFilename();
                File currentIncludeFile = new File(currentFilename);
                String parentDirectory = currentIncludeFile.getParent();
                currentIncludeFile = null;
                String fullPath = parentDirectory + File.separatorChar + fileName;
                File includeFile = new File(fullPath);
                if (includeFile.exists() && includeFile.isFile()) {
                    try {
                        FileReader inclusionReader = new FileReader(includeFile);
                        this.updateContext(inclusionReader, fullPath, 2);
                        return;
                    }
                    catch (FileNotFoundException fnf) {
                        if (!this.throwExceptionOnInclusionNotFound) break block9;
                        throw new ScannerException("Cannot find inclusion " + fileName);
                    }
                }
            }
        }
        if (this.throwExceptionOnInclusionNotFound) {
            throw new ScannerException("Cannot find inclusion " + fileName);
        }
    }

    public void setQuickScan(boolean qs) {
        this.quickScan = qs;
    }

    public void setCallback(IParserCallback c) {
        this.callback = c;
    }

    private int getChar() {
        boolean done;
        int c = -1;
        if (this.currentContext == null) {
            return c;
        }
        do {
            done = true;
            if (this.currentContext.undoStackSize() != 0) {
                c = this.currentContext.popUndo();
                continue;
            }
            try {
                c = this.currentContext.read();
                if (c != -1) continue;
                if (!this.rollbackContext()) {
                    c = -1;
                    break;
                }
                done = false;
            }
            catch (IOException e) {
                if (!this.rollbackContext()) {
                    c = -1;
                    continue;
                }
                done = false;
            }
        } while (!done);
        if (c == 92) {
            c = this.getChar();
            if (c == 13) {
                c = this.getChar();
                if (c == 10) {
                    c = this.getChar();
                }
            } else if (c == 10) {
                c = this.getChar();
            }
        }
        return c;
    }

    private void ungetChar(int c) {
        this.currentContext.pushUndo(c);
    }

    protected boolean lookAheadForTokenPasting() {
        int c = this.getChar();
        if (c == 35) {
            c = this.getChar();
            if (c == 35) {
                return true;
            }
            this.ungetChar(c);
        }
        this.ungetChar(c);
        return false;
    }

    public Token nextToken() throws ScannerException, Parser.EndOfFile {
        return this.nextToken(true);
    }

    /*
     * Unable to fully structure code
     */
    protected Token nextToken(boolean pasting) throws ScannerException, Parser.EndOfFile {
        ++this.count;
        c = this.getChar();
        block105: while (c != -1) {
            block144: {
                if (!this.passOnToClient) {
                    while (c != 35) {
                        c = this.getChar();
                    }
                }
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    c = this.getChar();
                    continue;
                }
                if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
                    buff = new StringBuffer();
                    buff.append((char)c);
                    c = this.getChar();
                    while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    this.ungetChar(c);
                    ident = buff.toString();
                    if (ident.equals("defined")) {
                        return this.newToken(2, this.handleDefinedMacro());
                    }
                    mapping = this.definitions.get(ident);
                    if (mapping != null) {
                        this.expandDefinition(ident, mapping);
                        c = this.getChar();
                        continue;
                    }
                    tokenTypeObject = Scanner.keywords.get(ident);
                    tokenType = 1;
                    if (tokenTypeObject != null) {
                        tokenType = (Integer)tokenTypeObject;
                    }
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            if (this.storageBuffer == null) {
                                this.storageBuffer = buff;
                            } else {
                                this.storageBuffer.append(ident);
                            }
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.storageBuffer.append(ident);
                            this.updateContext(new StringReader(this.storageBuffer.toString()), "<pasting>", 3);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    return this.newToken(tokenType, ident, this.currentContext);
                }
                if (c == 34) {
                    buff = new StringBuffer();
                    c = this.getChar();
                    while (c != 34 && c != 10) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    if (c != 10) {
                        return this.newToken(129, buff.toString(), this.currentContext);
                    }
                    if (!this.throwExceptionOnUnboundedString) continue;
                    throw new ScannerException("Unbounded string found at offset " + this.currentContext.getOffset());
                }
                if (c >= 48 && c <= 57) {
                    buff = pasting ? (this.storageBuffer != null ? this.storageBuffer : new StringBuffer()) : new StringBuffer();
                    buff.append((char)c);
                    c = this.getChar();
                    hex = false;
                    if (c == 120) {
                        hex = true;
                        c = this.getChar();
                    }
                    while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    this.ungetChar(c);
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            this.storageBuffer = buff;
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.updateContext(new StringReader(buff.toString()), "<pasting>", 3);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    return this.newToken(2, buff.toString(), this.currentContext);
                }
                if (c != 35) break block144;
                buff = new StringBuffer();
                buff.append((char)c);
                skipped = this.skipOverWhitespace();
                c = this.getChar();
                if (c != 35) ** GOTO lbl102
                if (skipped) {
                    throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.currentContext.getOffset());
                }
                return this.newToken(-6, "##");
lbl-1000:
                // 1 sources

                {
                    buff.append((char)c);
                    c = this.getChar();
lbl102:
                    // 2 sources

                    ** while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95)
                }
lbl103:
                // 1 sources

                this.ungetChar(c);
                token = buff.toString();
                directive = Scanner.ppDirectives.get(token);
                if (directive == null) {
                    if (!this.throwExceptionOnBadPreprocessorSyntax) continue;
                    throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.currentContext.getOffset());
                }
                type = (Integer)directive;
                switch (type) {
                    case 0: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block105;
                        }
                        this.poundDefine();
                        c = this.getChar();
                        continue block105;
                    }
                    case 7: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block105;
                        }
                        this.poundInclude();
                        c = this.getChar();
                        continue block105;
                    }
                    case 1: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block105;
                        }
                        this.skipOverWhitespace();
                        toBeUndefined = this.getNextIdentifier();
                        if (this.definitions.remove(toBeUndefined) == null && this.throwExceptionOnBadUndefinition) {
                            throw new ScannerException("Attempt to #undef symbol " + toBeUndefined + " when it was never defined");
                        }
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block105;
                    }
                    case 2: {
                        expression = this.getRestOfPreprocessorLine();
                        expressionEvalResult = this.evaluateExpression(expression);
                        this.passOnToClient = this.branches.poundif(expressionEvalResult);
                        c = this.getChar();
                        continue block105;
                    }
                    case 3: {
                        this.skipOverWhitespace();
                        definition = this.getNextIdentifier();
                        mapping = this.definitions.get(definition);
                        if (mapping == null) {
                            this.passOnToClient = this.branches.poundif(false);
                            this.skipOverTextUntilNewline();
                            continue block105;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block105;
                    }
                    case 6: {
                        restOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!restOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.currentContext.getOffset());
                        }
                        this.passOnToClient = this.branches.poundendif();
                        c = this.getChar();
                        continue block105;
                    }
                    case 4: {
                        this.skipOverWhitespace();
                        def = this.getNextIdentifier();
                        map = this.definitions.get(def);
                        if (map != null) {
                            this.skipOverTextUntilNewline();
                            this.passOnToClient = this.branches.poundif(false);
                            continue block105;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block105;
                    }
                    case 5: {
                        this.passOnToClient = this.branches.poundelse();
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block105;
                    }
                    case 12: {
                        elsifExpression = this.getRestOfPreprocessorLine();
                        if (elsifExpression.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Malformed #elsif clause");
                        }
                        elsifResult = this.evaluateExpression(elsifExpression);
                        this.passOnToClient = this.branches.poundelif(elsifResult);
                        c = this.getChar();
                        continue block105;
                    }
                    case 8: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block105;
                    }
                    case 9: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block105;
                        }
                        error = this.getRestOfPreprocessorLine();
                        if (this.throwExceptionPPError) {
                            throw new ScannerException("#error " + error);
                        }
                        c = this.getChar();
                        continue block105;
                    }
                    case 10: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block105;
                    }
                    case 11: {
                        remainderOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!remainderOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.currentContext.getOffset());
                        }
                        c = this.getChar();
                        continue block105;
                    }
                    default: {
                        if (!this.throwExceptionOnBadPreprocessorSyntax) continue block105;
                        throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.currentContext.getOffset());
                    }
                }
            }
            block15 : switch (c) {
                case 58: {
                    c = this.getChar();
                    switch (c) {
                        case 58: {
                            return this.newToken(3, "::", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(4, ":", this.currentContext);
                }
                case 59: {
                    return this.newToken(5, ";", this.currentContext);
                }
                case 44: {
                    return this.newToken(6, ",", this.currentContext);
                }
                case 63: {
                    return this.newToken(7, "?", this.currentContext);
                }
                case 40: {
                    return this.newToken(8, "(", this.currentContext);
                }
                case 41: {
                    return this.newToken(9, ")", this.currentContext);
                }
                case 91: {
                    return this.newToken(10, "[", this.currentContext);
                }
                case 93: {
                    return this.newToken(11, "]", this.currentContext);
                }
                case 123: {
                    return this.newToken(12, "{", this.currentContext);
                }
                case 125: {
                    return this.newToken(13, "}", this.currentContext);
                }
                case 43: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(14, "+=", this.currentContext);
                        }
                        case 43: {
                            return this.newToken(15, "++", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(16, "+", this.currentContext);
                }
                case 45: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(17, "-=", this.currentContext);
                        }
                        case 45: {
                            return this.newToken(18, "--", this.currentContext);
                        }
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 42: {
                                    return this.newToken(19, "->*", this.currentContext);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(20, "->", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(21, "-", this.currentContext);
                }
                case 42: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(22, "*=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(23, "*", this.currentContext);
                }
                case 37: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(24, "%=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(25, "%", this.currentContext);
                }
                case 94: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(26, "^=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(27, "^", this.currentContext);
                }
                case 38: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(28, "&=", this.currentContext);
                        }
                        case 38: {
                            return this.newToken(29, "&&", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(30, "&", this.currentContext);
                }
                case 124: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(31, "|=", this.currentContext);
                        }
                        case 124: {
                            return this.newToken(32, "||", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(33, "|", this.currentContext);
                }
                case 126: {
                    return this.newToken(34, "~", this.currentContext);
                }
                case 33: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(35, "!=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(36, "!", this.currentContext);
                }
                case 61: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(37, "==", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(38, "=", this.currentContext);
                }
                case 60: {
                    c = this.getChar();
                    switch (c) {
                        case 60: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(47, "<<=", this.currentContext);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(40, "<<", this.currentContext);
                        }
                        case 61: {
                            return this.newToken(41, "<=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(42, "<", this.currentContext);
                }
                case 62: {
                    c = this.getChar();
                    switch (c) {
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(43, ">>=", this.currentContext);
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(44, ">>", this.currentContext);
                        }
                        case 61: {
                            return this.newToken(45, ">=", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(46, ">", this.currentContext);
                }
                case 46: {
                    c = this.getChar();
                    switch (c) {
                        case 46: {
                            c = this.getChar();
                            switch (c) {
                                case 46: {
                                    return this.newToken(48, "...", this.currentContext);
                                }
                            }
                            break block15;
                        }
                        case 42: {
                            return this.newToken(49, ".*", this.currentContext);
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(50, ".", this.currentContext);
                }
                case 47: {
                    c = this.getChar();
                    switch (c) {
                        case 47: {
                            c = this.getChar();
                            while (c != 10 && c != -1) {
                                c = this.getChar();
                            }
                            continue block105;
                        }
                        case 42: {
                            this.skipOverMultilineComment();
                            c = this.getChar();
                            continue block105;
                        }
                        case 61: {
                            return this.newToken(51, "/=", this.currentContext);
                        }
                        default: {
                            this.ungetChar(c);
                            return this.newToken(52, "/", this.currentContext);
                        }
                    }
                }
                default: {
                    if (!this.throwExceptionOnBadCharacterRead) break;
                    throw new ScannerException("Invalid character read @ offset " + this.currentContext.getOffset() + " of file " + this.currentContext.getFilename());
                }
            }
            throw Parser.endOfFile;
        }
        if (this.throwExceptionOnEOFWithoutBalancedEndifs && this.getDepth() != 0) {
            throw new ScannerException("End of file encountered without terminating #endif");
        }
        throw Parser.endOfFile;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getDepth() {
        return this.branches.getDepth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean evaluateExpression(String expression) throws ScannerException {
        Object expressionEvalResult;
        block8: {
            if (this.quickScan) {
                return !expression.trim().equals("0");
            }
            expressionEvalResult = null;
            try {
                try {
                    ExpressionEvaluator evaluator = new ExpressionEvaluator();
                    Scanner trial = new Scanner(new StringReader(expression + ";"), EXPRESSION, this.definitions);
                    Parser parser = new Parser(trial, (IParserCallback)evaluator);
                    parser.expression(null);
                    expressionEvalResult = evaluator.getResult();
                }
                catch (Exception e) {
                    throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
                }
                Object var7_8 = null;
                if (expressionEvalResult != null) break block8;
                throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (expressionEvalResult != null) throw throwable;
                throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
            }
        }
        if (expressionEvalResult instanceof Integer) {
            int i = (Integer)expressionEvalResult;
            return i != 0;
        }
        if (!(expressionEvalResult instanceof Boolean)) throw new ScannerException("Unexpected expression type - we do not expect " + expressionEvalResult.getClass().getName());
        return (Boolean)expressionEvalResult;
    }

    protected boolean skipOverMultilineComment() throws ScannerException {
        int state = 0;
        boolean encounteredNewline = false;
        int c = this.getChar();
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar();
        }
        if (c == -1 && this.throwExceptionOnEOFWithinMultilineComment) {
            throw new ScannerException("Encountered EOF while in multiline comment");
        }
        this.ungetChar(c);
        return encounteredNewline;
    }

    protected void poundInclude() throws ScannerException {
        this.skipOverWhitespace();
        int c = this.getChar();
        StringBuffer fileName = new StringBuffer();
        boolean useIncludePath = true;
        if (c == 60) {
            c = this.getChar();
            while (c != 62) {
                fileName.append((char)c);
                c = this.getChar();
            }
        } else if (c == 34) {
            c = this.getChar();
            while (c != 34) {
                fileName.append((char)c);
                c = this.getChar();
            }
            useIncludePath = false;
        }
        String f = fileName.toString();
        if (this.quickScan) {
            if (this.callback != null) {
                int offset = this.currentContext.getOffset() - f.length() - 1;
                this.callback.inclusionBegin(f, offset);
                this.callback.inclusionEnd();
            }
        } else {
            this.handleInclusion(f.trim(), useIncludePath);
        }
    }

    protected void poundDefine() throws ScannerException, Parser.EndOfFile {
        String checkForRedefinition;
        this.skipOverWhitespace();
        String key = this.getNextIdentifier();
        int offset = this.currentContext.getOffset() - key.length() - this.currentContext.undoStackSize();
        if (this.throwExceptionOnRedefinition && (checkForRedefinition = (String)this.definitions.get(key)) != null) {
            throw new ScannerException("Preprocessor symbol " + key + " has already been defined to " + checkForRedefinition + " cannot redefined.");
        }
        int c = this.getChar();
        if (c == 40) {
            StringBuffer buffer = new StringBuffer();
            c = this.getChar();
            while (c != 41) {
                buffer.append((char)c);
                c = this.getChar();
            }
            String parameters = buffer.toString();
            StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
            ArrayList<String> parameterIdentifiers = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                parameterIdentifiers.add(tokenizer.nextToken().trim());
            }
            this.skipOverWhitespace();
            ArrayList<Token> macroReplacementTokens = new ArrayList<Token>();
            String replacementString = this.getRestOfPreprocessorLine();
            Scanner helperScanner = new Scanner();
            helperScanner.initialize(new StringReader(replacementString), null);
            Token t = helperScanner.nextToken(false);
            try {
                while (true) {
                    macroReplacementTokens.add(t);
                    t = helperScanner.nextToken(false);
                }
            }
            catch (Parser.EndOfFile e) {
                MacroDescriptor descriptor = new MacroDescriptor();
                descriptor.initialize(key, parameterIdentifiers, macroReplacementTokens, key + "(" + parameters + ")");
                this.addDefinition(key, descriptor);
            }
        } else if (c == 32 || c == 9 || c == 10 || c == 13) {
            this.skipOverWhitespace();
            String value = this.getRestOfPreprocessorLine();
            this.addDefinition(key, value);
        } else if (c == 47) {
            c = this.getChar();
            if (c == 47) {
                this.skipOverTextUntilNewline();
                this.addDefinition(key, "");
            } else if (c == 42) {
                if (this.skipOverMultilineComment()) {
                    this.addDefinition(key, "");
                } else {
                    String value = this.getRestOfPreprocessorLine();
                    this.addDefinition(key, value);
                }
            } else if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(BAD_PP + this.currentContext.getOffset());
            }
        } else {
            System.out.println("Unexpected character " + (char)c);
            if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(BAD_PP + this.currentContext.getOffset());
            }
        }
        if (this.callback != null) {
            this.callback.macro(key, offset);
        }
    }

    protected void expandDefinition(String symbol, Object expansion) throws ScannerException {
        if (expansion instanceof String) {
            String replacementValue = (String)expansion;
            this.updateContext(new StringReader(replacementValue), POUND_DEFINE + symbol, 3);
        } else if (expansion instanceof IMacroDescriptor) {
            IMacroDescriptor macro = (IMacroDescriptor)expansion;
            this.skipOverWhitespace();
            int c = this.getChar();
            if (c == 40) {
                StringBuffer buffer = new StringBuffer();
                int bracketCount = 1;
                c = this.getChar();
                while (true) {
                    if (c == 40) {
                        ++bracketCount;
                    } else if (c == 41) {
                        --bracketCount;
                    }
                    if (bracketCount == 0) break;
                    buffer.append((char)c);
                    c = this.getChar();
                }
                String betweenTheBrackets = buffer.toString().trim();
                StringTokenizer tokenizer = new StringTokenizer(betweenTheBrackets, ",");
                Vector<String> parameterValues = new Vector<String>(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    parameterValues.add(tokenizer.nextToken().trim());
                }
                buffer = new StringBuffer();
                List tokens = macro.getTokenizedExpansion();
                List parameterNames = macro.getParameters();
                if (parameterNames.size() != parameterValues.size() && this.throwExceptionOnBadMacroExpansion) {
                    throw new ScannerException("Improper use of macro " + symbol);
                }
                int numberOfTokens = tokens.size();
                int i = 0;
                while (i < numberOfTokens) {
                    Token t2;
                    Token t = (Token)tokens.get(i);
                    if (t.type == 1) {
                        String identifierName = t.image;
                        int index = parameterNames.indexOf(t.image);
                        if (index == -1) {
                            buffer.append(t.image);
                        } else {
                            buffer.append((String)parameterValues.elementAt(index));
                        }
                    } else {
                        buffer.append(t.image);
                    }
                    boolean pastingNext = false;
                    if (i != numberOfTokens - 1 && (t2 = (Token)tokens.get(i + 1)).getType() == -6) {
                        pastingNext = true;
                    }
                    if (t.getType() != -6 && !pastingNext) {
                        buffer.append(" ");
                    }
                    ++i;
                }
                String finalString = buffer.toString();
                this.updateContext(new StringReader(finalString), POUND_DEFINE + macro.getSignature(), 3);
            } else if (this.throwExceptionOnBadMacroExpansion) {
                throw new ScannerException("Improper use of macro " + symbol);
            }
        } else {
            System.out.println("Unexpected class stored in definitions table. " + expansion.getClass().getName());
        }
    }

    protected String handleDefinedMacro() throws ScannerException {
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c != 40 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException("Improper use of macro defined()");
        }
        StringBuffer buffer = new StringBuffer();
        c = this.getChar();
        while (c != -1 && c != 41) {
            buffer.append((char)c);
            c = this.getChar();
        }
        if (c == -1 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException("Improper use of macro defined()");
        }
        String definitionIdentifier = buffer.toString().trim();
        if (this.definitions.get(definitionIdentifier) != null) {
            return "1";
        }
        return "0";
    }

    static {
        keywords.put("and", new Integer(54));
        keywords.put("and_eq", new Integer(55));
        keywords.put("asm", new Integer(56));
        keywords.put("auto", new Integer(57));
        keywords.put("bitand", new Integer(58));
        keywords.put("bitor", new Integer(59));
        keywords.put("bool", new Integer(60));
        keywords.put("break", new Integer(61));
        keywords.put("case", new Integer(62));
        keywords.put("catch", new Integer(63));
        keywords.put("char", new Integer(64));
        keywords.put("class", new Integer(65));
        keywords.put("compl", new Integer(66));
        keywords.put("const", new Integer(67));
        keywords.put("const_cast", new Integer(69));
        keywords.put("continue", new Integer(70));
        keywords.put("default", new Integer(71));
        keywords.put("delete", new Integer(72));
        keywords.put("do", new Integer(73));
        keywords.put("double", new Integer(74));
        keywords.put("dynamic_cast", new Integer(75));
        keywords.put("else", new Integer(76));
        keywords.put("enum", new Integer(77));
        keywords.put("explicit", new Integer(78));
        keywords.put("export", new Integer(79));
        keywords.put("extern", new Integer(80));
        keywords.put("false", new Integer(81));
        keywords.put("float", new Integer(82));
        keywords.put("for", new Integer(83));
        keywords.put("friend", new Integer(84));
        keywords.put("goto", new Integer(85));
        keywords.put("if", new Integer(86));
        keywords.put("inline", new Integer(87));
        keywords.put("int", new Integer(88));
        keywords.put("long", new Integer(89));
        keywords.put("mutable", new Integer(90));
        keywords.put("namespace", new Integer(91));
        keywords.put("new", new Integer(92));
        keywords.put("not", new Integer(93));
        keywords.put("not_eq", new Integer(94));
        keywords.put("operator", new Integer(95));
        keywords.put("or", new Integer(96));
        keywords.put("or_eq", new Integer(97));
        keywords.put("private", new Integer(98));
        keywords.put("protected", new Integer(99));
        keywords.put("public", new Integer(100));
        keywords.put("register", new Integer(101));
        keywords.put("reinterpret_cast", new Integer(102));
        keywords.put("return", new Integer(103));
        keywords.put("short", new Integer(104));
        keywords.put("signed", new Integer(108));
        keywords.put("sizeof", new Integer(105));
        keywords.put("static", new Integer(106));
        keywords.put("static_cast", new Integer(107));
        keywords.put("struct", new Integer(109));
        keywords.put("switch", new Integer(110));
        keywords.put("template", new Integer(111));
        keywords.put("this", new Integer(112));
        keywords.put("throw", new Integer(113));
        keywords.put("true", new Integer(114));
        keywords.put("try", new Integer(115));
        keywords.put("typedef", new Integer(116));
        keywords.put("typeid", new Integer(117));
        keywords.put("typename", new Integer(118));
        keywords.put("union", new Integer(119));
        keywords.put("unsigned", new Integer(120));
        keywords.put("using", new Integer(121));
        keywords.put("virtual", new Integer(122));
        keywords.put("void", new Integer(123));
        keywords.put("volatile", new Integer(124));
        keywords.put("wchar_t", new Integer(125));
        keywords.put("while", new Integer(126));
        keywords.put("xor", new Integer(127));
        keywords.put("xor_eq", new Integer(128));
        ppDirectives.put("#define", new Integer(0));
        ppDirectives.put("#undef", new Integer(1));
        ppDirectives.put("#if", new Integer(2));
        ppDirectives.put("#ifdef", new Integer(3));
        ppDirectives.put("#ifndef", new Integer(4));
        ppDirectives.put("#else", new Integer(5));
        ppDirectives.put("#endif", new Integer(6));
        ppDirectives.put("#include", new Integer(7));
        ppDirectives.put("#line", new Integer(8));
        ppDirectives.put("#error", new Integer(9));
        ppDirectives.put("#pragma", new Integer(10));
        ppDirectives.put("#elif", new Integer(12));
        ppDirectives.put("#", new Integer(11));
    }

    public static class PreprocessorDirectives {
        public static final int DEFINE = 0;
        public static final int UNDEFINE = 1;
        public static final int IF = 2;
        public static final int IFDEF = 3;
        public static final int IFNDEF = 4;
        public static final int ELSE = 5;
        public static final int ENDIF = 6;
        public static final int INCLUDE = 7;
        public static final int LINE = 8;
        public static final int ERROR = 9;
        public static final int PRAGMA = 10;
        public static final int BLANK = 11;
        public static final int ELIF = 12;
    }
}

