/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.utils.elf.ERandomAccessFile;
import org.eclipse.cdt.utils.elf.Elf;

public class AR {
    protected String filename;
    protected ERandomAccessFile efile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public AR(String filename) throws IOException {
        this.filename = filename;
        this.efile = new ERandomAccessFile(filename, "r");
        String hdr = this.efile.readLine();
        if (hdr == null || hdr.compareTo("!<arch>") != 0) {
            this.efile.close();
            throw new IOException("Not a valid archive file.");
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            while (this.efile.getFilePointer() < this.efile.length()) {
                ARHeader header = new ARHeader();
                String name = header.getObjectName();
                long pos = this.efile.getFilePointer();
                if (name.charAt(0) != '/') {
                    v.add(header);
                }
                if (name.compareTo("//") == 0) {
                    this.strtbl_pos = pos;
                }
                if ((pos += header.getSize()) % 2L != 0L) {
                    ++pos;
                }
                this.efile.seek(pos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.headers = v.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String str, String[] set) {
        int i = 0;
        while (i < set.length) {
            if (str.compareTo(set[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        int i = 0;
        while (i < this.headers.length) {
            String object_name = this.headers[i].getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = "" + count + "_" + object_name;
                ++count;
                byte[] data = this.headers[i].getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++i;
        }
        return names_used.toArray(new String[0]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    public class ARHeader {
        private String object_name;
        private String modification_time;
        private String uid;
        private String gid;
        private String mode;
        private long size;
        private long elf_offset;

        private String removeBlanks(String str) {
            while (str.charAt(str.length() - 1) == ' ') {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        /*
         * WARNING - void declaration
         */
        private String nameFromStringTable(long offset) throws IOException {
            StringBuffer name = new StringBuffer(0);
            long pos = AR.this.efile.getFilePointer();
            try {
                if (AR.this.strtbl_pos != -1L) {
                    byte temp;
                    AR.this.efile.seek(AR.this.strtbl_pos + offset);
                    while ((temp = AR.this.efile.readByte()) != 10) {
                        void var6_4;
                        name.append((char)var6_4);
                    }
                }
                Object var8_5 = null;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                AR.this.efile.seek(pos);
                throw throwable;
            }
            AR.this.efile.seek(pos);
            return name.toString();
        }

        public ARHeader() throws IOException {
            int len;
            byte[] object_name = new byte[16];
            byte[] modification_time = new byte[12];
            byte[] uid = new byte[6];
            byte[] gid = new byte[6];
            byte[] mode = new byte[8];
            byte[] size = new byte[10];
            byte[] trailer = new byte[2];
            AR.this.efile.read(object_name);
            AR.this.efile.read(modification_time);
            AR.this.efile.read(uid);
            AR.this.efile.read(gid);
            AR.this.efile.read(mode);
            AR.this.efile.read(size);
            AR.this.efile.read(trailer);
            this.elf_offset = AR.this.efile.getFilePointer();
            this.object_name = this.removeBlanks(new String(object_name));
            this.modification_time = new String(modification_time);
            this.uid = new String(uid);
            this.gid = new String(gid);
            this.mode = new String(mode);
            this.size = Long.parseLong(this.removeBlanks(new String(size)));
            if (AR.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long offset = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(offset);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((len = this.object_name.length()) > 2 && this.object_name.charAt(len - 1) == '/') {
                this.object_name = this.object_name.substring(0, len - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public Elf getElf() throws IOException {
            return new Elf(AR.this.filename, this.elf_offset);
        }

        public Elf getElf(boolean filter_on) throws IOException {
            return new Elf(AR.this.filename, this.elf_offset, filter_on);
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            if (AR.this.efile != null) {
                AR.this.efile.seek(this.elf_offset);
                AR.this.efile.read(temp);
            } else {
                AR.this.efile = new ERandomAccessFile(AR.this.filename, "r");
                AR.this.efile.seek(this.elf_offset);
                AR.this.efile.read(temp);
                AR.this.efile.close();
                AR.this.efile = null;
            }
            return temp;
        }
    }
}

