/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class CastToArrayActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICastToArray fCastToArray = null;
    private IStatus fStatus = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getCastToArray() == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    CastToArrayActionDelegate.this.doAction(CastToArrayActionDelegate.this.getCastToArray());
                    CastToArrayActionDelegate.this.setStatus(null);
                }
                catch (DebugException e) {
                    CastToArrayActionDelegate.this.setStatus(e.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog("Unable to display this variable as an array.", this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICastToArray) {
            boolean enabled = ((ICastToArray)element).supportsCastToArray();
            action.setEnabled(enabled);
            if (enabled) {
                this.setCastToArray((ICastToArray)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setCastToArray(null);
    }

    protected ICastToArray getCastToArray() {
        return this.fCastToArray;
    }

    protected void setCastToArray(ICastToArray castToArray) {
        this.fCastToArray = castToArray;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void doAction(ICastToArray castToArray) throws DebugException {
        String currentType = castToArray.getCurrentType().trim();
        CastToArrayDialog dialog = new CastToArrayDialog(CDebugUIPlugin.getActiveWorkbenchShell(), currentType, 0, 1);
        if (dialog.open() == 0) {
            String newType = dialog.getType().trim();
            int firstIndex = dialog.getFirstIndex();
            int lastIndex = dialog.getLength();
            castToArray.castToArray(newType, firstIndex, lastIndex);
        }
    }

    protected class CastToArrayDialog
    extends Dialog {
        private String fType = "";
        private int fFirstIndex = 0;
        private int fLength = 0;
        private Button fOkButton;
        private Label fErrorMessageLabel;
        private Text fTypeText;
        private Text fFirstIndexText;
        private Text fLengthText;

        public CastToArrayDialog(Shell parentShell, String initialType, int initialStart, int initialLength) {
            super(parentShell);
            this.fType = initialType == null ? "" : initialType;
            this.fFirstIndex = initialStart;
            this.fLength = initialLength;
        }

        protected String getType() {
            return this.fType;
        }

        protected int getFirstIndex() {
            return this.fFirstIndex;
        }

        protected int getLength() {
            return this.fLength;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Display As Array");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.fTypeText.setFocus();
            if (this.fType != null) {
                this.fTypeText.setText(this.fType);
                this.fTypeText.selectAll();
                this.fFirstIndexText.setText(String.valueOf(this.fFirstIndex));
                this.fLengthText.setText(String.valueOf(this.fLength));
            }
        }

        protected Label getErrorMessageLabel() {
            return this.fErrorMessageLabel;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createDialogFields(composite);
            this.fErrorMessageLabel = new Label(composite, 0);
            this.fErrorMessageLabel.setLayoutData((Object)new GridData(768));
            this.fErrorMessageLabel.setFont(parent.getFont());
            return composite;
        }

        private void createDialogFields(Composite parent) {
            Composite composite = ControlFactory.createComposite((Composite)parent, (int)4);
            ((GridData)composite.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(300);
            ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = true;
            ControlFactory.createLabel((Composite)composite, (String)"Type:");
            this.fTypeText = ControlFactory.createTextField((Composite)composite);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.fTypeText.setLayoutData((Object)data);
            this.fTypeText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ CastToArrayDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validateInput();
                }
            });
            Label label = ControlFactory.createLabel((Composite)composite, (String)"Start index:");
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fFirstIndexText = ControlFactory.createTextField((Composite)composite);
            this.fFirstIndexText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ CastToArrayDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validateInput();
                }
            });
            label = ControlFactory.createLabel((Composite)composite, (String)"Length:");
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fLengthText = ControlFactory.createTextField((Composite)composite);
            this.fLengthText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ CastToArrayDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validateInput();
                }
            });
        }

        protected void validateInput() {
            boolean enabled = true;
            String message = "";
            if (this.fTypeText.getText().trim().length() == 0) {
                message = "The 'Type' field must not be empty.";
                enabled = false;
            } else {
                String firstIndex = this.fFirstIndexText.getText().trim();
                if (firstIndex.length() == 0) {
                    message = "The 'First index' field must not be empty.";
                    enabled = false;
                } else {
                    try {
                        Integer.parseInt(firstIndex);
                    }
                    catch (NumberFormatException e) {
                        message = "Invalid first index.";
                        enabled = false;
                    }
                    if (enabled) {
                        String lengthText = this.fLengthText.getText().trim();
                        if (lengthText.length() == 0) {
                            message = "The 'Last index' field must not be empty.";
                            enabled = false;
                        } else {
                            int length = -1;
                            try {
                                length = Integer.parseInt(lengthText);
                            }
                            catch (NumberFormatException e) {
                                message = "Invalid last index.";
                                enabled = false;
                            }
                            if (enabled && length < 1) {
                                message = "The length must be greater than 0.";
                                enabled = false;
                            }
                        }
                    }
                }
            }
            this.fOkButton.setEnabled(enabled);
            this.getErrorMessageLabel().setText(message);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.fType = this.fTypeText.getText().trim();
                String firstIndex = this.fFirstIndexText.getText().trim();
                String lengthText = this.fLengthText.getText().trim();
                try {
                    this.fFirstIndex = Integer.parseInt(firstIndex);
                    this.fLength = Integer.parseInt(lengthText);
                }
                catch (NumberFormatException e) {
                    this.fFirstIndex = 0;
                    this.fLength = 0;
                }
            } else {
                this.fType = null;
            }
            super.buttonPressed(buttonId);
        }
    }
}

