/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.ICSignalManager;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class SignalsView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICSignalManager;

    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SignalsViewer vv = new SignalsViewer(parent, 770);
        vv.setContentProvider((IContentProvider)new SignalsViewContentProvider());
        vv.setLabelProvider((IBaseLabelProvider)new SignalsViewLabelProvider());
        vv.setUseHashlookup(true);
        vv.setExceptionHandler(this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(new SignalsViewEventHandler(this));
        return vv;
    }

    protected void createActions() {
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SIGNALS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void handleException(DebugException e) {
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)e.getMessage(), null);
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        ICSignalManager sm = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            sm = (ICSignalManager)((IDebugElement)input).getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$ICSignalManager == null ? (class$org$eclipse$cdt$debug$core$ICSignalManager = SignalsView.class$("org.eclipse.cdt.debug.core.ICSignalManager")) : class$org$eclipse$cdt$debug$core$ICSignalManager);
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current != null && current.equals(sm)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(sm);
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        SignalsViewContentProvider cp = new SignalsViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SignalsViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return CDebugUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_SIGNAL, 0));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICSignal) {
                switch (columnIndex) {
                    case 0: {
                        return ((ICSignal)element).getName();
                    }
                    case 1: {
                        return ((ICSignal)element).isPassEnabled() ? "yes" : "no";
                    }
                    case 2: {
                        return ((ICSignal)element).isStopEnabled() ? "yes" : "no";
                    }
                    case 3: {
                        return ((ICSignal)element).getDescription();
                    }
                }
            }
            return null;
        }
    }
}

