/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.IAsyncExecutor;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.core.model.ISwitchToThread;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.internal.ui.editors.CDebugDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.preferences.CDebugPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.MemoryViewPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.RegistersViewPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.SharedLibrariesViewPreferencePage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CDebugUIPlugin
extends AbstractUIPlugin
implements ISelectionListener,
IDebugEventSetListener,
IAsyncExecutor {
    private static CDebugUIPlugin plugin;
    private ResourceBundle resourceBundle;
    protected Map fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;
    private DisassemblyDocumentProvider fDisassemblyDocumentProvider = null;
    private CDebugDocumentProvider fDocumentProvider;

    public CDebugUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.ui.CDebugUIPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CDebugUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.debug.ui";
        }
        return CDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    protected void initializeDefaultPreferences(IPreferenceStore pstore) {
        MemoryViewPreferencePage.initDefaults(pstore);
        RegistersViewPreferencePage.initDefaults(pstore);
        SharedLibrariesViewPreferencePage.initDefaults(pstore);
        CDebugPreferencePage.initDefaults(pstore);
    }

    public static CDTDebugModelPresentation getDebugModelPresentation() {
        return CDTDebugModelPresentation.getDefault();
    }

    public static void log(IStatus status) {
        CDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static void logErrorMessage(String message) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public ILaunchConfigurationTab getDebuggerPage(String debuggerID) {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fDebuggerPageMap.get(debuggerID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 100, "An error occurred retrieving a C Debugger page", (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IPluginDescriptor descriptor = CDebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CDebuggerPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("debuggerID");
            this.fDebuggerPageMap.put(id, infos[i]);
            ++i;
        }
    }

    public static void errorDialog(String message, IStatus status) {
        CDebugUIPlugin.log(status);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        CDebugUIPlugin.log(t);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public void shutdown() throws CoreException {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        IWorkbenchWindow ww = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (ww != null) {
            ww.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        CDebugCorePlugin.getDefault().setAsyncExecutor(null);
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        IWorkbenchWindow ww = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (ww != null) {
            ww.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        CDebugCorePlugin.getDefault().setAsyncExecutor((IAsyncExecutor)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element != null && element instanceof IThread) {
                if (((IThread)element).getDebugTarget() instanceof ISwitchToThread) {
                    try {
                        if (!this.sameThread((IDebugElement)element)) {
                            ((ISwitchToThread)((IThread)element).getDebugTarget()).setCurrentThread((IThread)element);
                        }
                    }
                    catch (DebugException e) {
                        CDebugUIPlugin.errorDialog(e.getMessage(), e);
                    }
                }
            } else if (element != null && element instanceof IStackFrame && ((IStackFrame)element).getThread() instanceof ISwitchToFrame) {
                try {
                    if (!this.sameThread((IDebugElement)element)) {
                        ((ISwitchToThread)((IStackFrame)element).getDebugTarget()).setCurrentThread(((IStackFrame)element).getThread());
                    }
                    ((ISwitchToFrame)((IStackFrame)element).getThread()).switchToFrame((IStackFrame)element);
                }
                catch (DebugException e) {
                    CDebugUIPlugin.errorDialog("Switch to stack frame failed.", e);
                }
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object element;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (element = event.getSource()) != null && element instanceof IDebugTarget) {
                this.closeDisassemblyEditors((IDebugTarget)element);
            }
            ++i;
        }
    }

    private void closeDisassemblyEditors(IDebugTarget target) {
        IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] refs = pages[j].getEditorReferences();
                int k = 0;
                while (k < refs.length) {
                    IEditorInput input;
                    IEditorPart editor = refs[k].getEditor(false);
                    if (editor != null && (input = editor.getEditorInput()) != null && input instanceof DisassemblyEditorInput) {
                        try {
                            Display display;
                            Shell shell;
                            IStorage storage = ((DisassemblyEditorInput)input).getStorage();
                            if (storage != null && storage instanceof IDisassemblyStorage && target.equals(((IDisassemblyStorage)storage).getDebugTarget()) && (shell = windows[i].getShell()) != null && (display = shell.getDisplay()) != null) {
                                final IWorkbenchPage page = pages[j];
                                final IEditorPart editor0 = editor;
                                display.asyncExec(new Runnable(){

                                    public void run() {
                                        page.closeEditor(editor0, false);
                                    }
                                });
                            }
                        }
                        catch (CoreException e) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean sameThread(IDebugElement element) throws DebugException {
        if (element.getDebugTarget() instanceof ISwitchToThread) {
            if (element instanceof IThread) {
                return ((IThread)element).equals(((ISwitchToThread)element.getDebugTarget()).getCurrentThread());
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).getThread().equals(((ISwitchToThread)element.getDebugTarget()).getCurrentThread());
            }
        }
        return false;
    }

    public DisassemblyDocumentProvider getDisassemblyDocumentProvider() {
        if (this.fDisassemblyDocumentProvider == null) {
            this.fDisassemblyDocumentProvider = new DisassemblyDocumentProvider();
        }
        return this.fDisassemblyDocumentProvider;
    }

    public void asyncExec(Runnable runnable) {
        Display display = CDebugUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public CDebugDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDebugDocumentProvider();
        }
        return this.fDocumentProvider;
    }
}

