/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartition;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class CValue
extends CDebugElement
implements ICValue {
    private CVariable fParent = null;
    private String fValueString = null;
    private ICDIValue fCDIValue;
    private List fVariables = Collections.EMPTY_LIST;

    public CValue(CVariable parent, ICDIValue cdiValue) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
        this.fCDIValue = cdiValue;
    }

    public String getReferenceTypeName() throws DebugException {
        String typeName = null;
        try {
            if (this.fCDIValue != null) {
                typeName = this.fCDIValue.getTypeName();
            }
        }
        catch (CDIException e) {
            this.logError(e);
        }
        return typeName;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            try {
                this.fValueString = this.processCDIValue(this.getUnderlyingValue().getValueString());
            }
            catch (CDIException e) {
                this.logError(e);
                this.fValueString = e.getMessage();
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            List vars = this.getCDIVariables();
            if (vars.size() > 1) {
                this.fVariables = CArrayPartition.splitArray(this, vars, 0, vars.size() - 1);
            } else {
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(new CModificationVariable(this, (ICDIVariable)it.next()));
                }
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null) {
                return value.getChildrenNumber() > 0;
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return false;
    }

    public ICDIValue getUnderlyingValue() {
        return this.fCDIValue;
    }

    protected List getCDIVariables() throws DebugException {
        ICDIVariable[] vars = null;
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null && (vars = value.getVariables()) == null) {
                vars = new ICDIVariable[]{};
            }
        }
        catch (CDIException e) {
            vars = new ICDIVariable[]{};
            this.infoMessage(e);
        }
        return Arrays.asList(vars);
    }

    protected int getNumberOfChildren() throws DebugException {
        int result = 0;
        try {
            result = this.getUnderlyingValue().getChildrenNumber();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return result;
    }

    protected String processCDIValue(String cdiValue) {
        String result = null;
        if (cdiValue != null) {
            result = cdiValue.trim();
        }
        return result;
    }

    public synchronized void setChanged(boolean changed) throws DebugException {
        if (changed) {
            this.fValueString = null;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).setChanged(changed);
        }
    }

    protected void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).dispose();
        }
    }

    protected CVariable getParentVariable() {
        return this.fParent;
    }
}

