/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CProjectSourceLocation
implements IProjectSourceLocation {
    private static final String ELEMENT_NAME = "cProjectSourceLocation";
    private static final String ATTR_PROJECT = "project";
    private IProject fProject;
    private HashMap fCache = new HashMap(20);
    private HashSet fNotFoundCache = new HashSet(20);
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public CProjectSourceLocation() {
    }

    public CProjectSourceLocation(IProject project) {
        this.setProject(project);
    }

    public Object findSourceElement(String name) throws CoreException {
        Object result = null;
        if (this.getProject() != null && !this.notFoundCacheLookup(name)) {
            result = this.cacheLookup(name);
            if (result == null && (result = this.doFindSourceElement(name)) != null) {
                this.cacheSourceElement(name, result);
            }
            if (result == null) {
                this.cacheNotFound(name);
            }
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation = CProjectSourceLocation.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$CProjectSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = CProjectSourceLocation.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject)) {
            return this.getProject();
        }
        return null;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private Object doFindSourceElement(String name) {
        File file = new File(name);
        return file.isAbsolute() ? this.findFileByAbsolutePath(name) : this.findFileByRelativePath((IContainer)this.getProject(), name);
    }

    private Object findFileByAbsolutePath(String name) {
        Path path = new Path(name);
        return this.findFile((IContainer)this.getProject(), path.toOSString());
    }

    private Object findFileByRelativePath(IContainer container, String fileName) {
        IPath rootPath = container.getLocation();
        IPath path = rootPath.append(fileName);
        Object result = this.findFileByAbsolutePath(path.toOSString());
        if (result == null) {
            try {
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IFolder) {
                        path = members[i].getLocation().append(fileName);
                        result = this.findFileByAbsolutePath(path.toOSString());
                        if (result == null) {
                            result = this.findFileByRelativePath((IContainer)((IFolder)members[i]), fileName);
                        }
                        if (result != null) break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return result;
    }

    private Object findFile(IContainer container, String fileName) {
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                Object result;
                if (members[i] instanceof IFile) {
                    if (members[i].getLocation().toOSString().equals(fileName)) {
                        return members[i];
                    }
                } else if (members[i] instanceof IFolder && fileName.startsWith(members[i].getLocation().toOSString()) && (result = this.findFile((IContainer)members[i], fileName)) != null) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private Object cacheLookup(String name) {
        return this.fCache.get(name);
    }

    private boolean notFoundCacheLookup(String name) {
        return this.fNotFoundCache.contains(name);
    }

    private void cacheSourceElement(String name, Object element) {
        this.fCache.put(name, element);
    }

    private void cacheNotFound(String name) {
        this.fNotFoundCache.add(name);
    }

    protected void dispose() {
        this.fCache.clear();
        this.fNotFoundCache.clear();
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement(ELEMENT_NAME);
        doc.appendChild(node);
        node.setAttribute(ATTR_PROJECT, this.getProject().getName());
        try {
            return CDebugUtils.serializeDocument((Document)doc, " ");
        }
        catch (IOException e) {
            this.abort(MessageFormat.format("Unable to create memento for C/C++ project source location {0}.", this.getProject().getName()), e);
            return null;
        }
    }

    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String name = root.getAttribute(ATTR_PROJECT);
            if (this.isEmpty(name)) {
                this.abort("Unable to initialize source location - missing project name", null);
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                this.setProject(project);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source location.", ex);
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

