/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ResourceTransfer;

class CViewDragAdapter
extends DragSourceAdapter {
    ISelectionProvider selectionProvider;

    public void dragFinished(DragSourceEvent event) {
        if (event.doit && event.detail == 2) {
            int typeMask = 3;
            IResource[] resources = this.getSelectedResources(3);
            if (resources == null) {
                return;
            }
            int i = 0;
            while (i < resources.length) {
                try {
                    resources[i].delete(true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        int typeMask = 3;
        IResource[] resources = this.getSelectedResources(3);
        if (resources == null || resources.length == 0) {
            return;
        }
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = resources;
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        int len = resources.length;
        String[] fileNames = new String[len];
        int i = 0;
        int length = len;
        while (i < length) {
            fileNames[i] = resources[i].getLocation().toOSString();
            ++i;
        }
        event.data = fileNames;
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            IResource res = null;
            if (next instanceof ICElement) {
                ICElement celement = (ICElement)next;
                res = celement.getResource();
            }
            if (res != null) continue;
            event.doit = false;
            return;
        }
        event.doit = true;
    }

    protected IResource[] getSelectedResources(int resourceTypes) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] result = new IResource[]{};
        ISelection selection = this.selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection == null) {
            return null;
        }
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof ICElement)) continue;
            try {
                IResource res = ((ICElement)obj).getUnderlyingResource();
                if (res == null || (res.getType() & resourceTypes) != res.getType()) continue;
                resources.add(res);
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
        result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }

    public CViewDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }
}

