/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class CWorkingSetFilter
extends ViewerFilter {
    public static final String WORKING_SET_ACTIVE_CHANGED = CUIPlugin.getPluginId() + ".ACTIVE_CHANGED";
    private IWorkingSetManager fWorkingSetManager;
    private IWorkingSet fWorkingSet;
    private String fWorkingSetName;
    private ArrayList fListeners;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public CWorkingSetFilter() {
        this(null);
    }

    public CWorkingSetFilter(IWorkingSetManager manager) {
        this.fWorkingSetManager = manager;
        this.fWorkingSet = null;
        this.fListeners = new ArrayList(1);
    }

    public void setWorkingSetManager(IWorkingSetManager manager) {
        this.fWorkingSetManager = manager;
    }

    public void setWorkingSetName(String name) {
        this.fWorkingSetName = name;
        if (name == null) {
            this.fWorkingSet = null;
            this.notifyChange();
            return;
        }
        this.fWorkingSet = this.fWorkingSetManager != null ? this.fWorkingSetManager.getWorkingSet(this.fWorkingSetName) : null;
        this.notifyChange();
    }

    public String getWorkingSetName() {
        return this.fWorkingSetName;
    }

    public void addChangeListener(IPropertyChangeListener listener) {
        ((AbstractCollection)this.fListeners).remove(listener);
        this.fListeners.add(listener);
    }

    public void removeChangeListener(IPropertyChangeListener listener) {
        ((AbstractCollection)this.fListeners).remove(listener);
    }

    private void notifyChange() {
        PropertyChangeEvent ev = new PropertyChangeEvent((Object)this, WORKING_SET_ACTIVE_CHANGED, null, null);
        int i = 0;
        while (i < this.fListeners.size()) {
            IPropertyChangeListener l = (IPropertyChangeListener)this.fListeners.get(i);
            l.propertyChange(ev);
            ++i;
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null) {
            return true;
        }
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = CWorkingSetFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        if (!(resource instanceof IProject)) {
            return true;
        }
        IAdaptable[] adaptables = this.fWorkingSet.getElements();
        int i = 0;
        while (i < adaptables.length) {
            if (adaptables[i].equals(resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

