/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.IWorkingCopyManager;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.SearchForReferencesAction;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private CEditor fEditor;
    private WorkingCopy fInput;
    private ProblemTreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private OpenIncludeAction fOpenIncludeAction;
    private SearchForReferencesAction fSearchForReferencesAction;

    public CContentOutlinePage(CEditor editor) {
        this.fEditor = editor;
        this.fInput = null;
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
        this.fSearchForReferencesAction = new SearchForReferencesAction((ISelectionProvider)this);
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public void contentUpdated() {
        if (this.fInput != null) {
            try {
                this.fInput.reconcile();
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e.getStatus());
                this.fInput = null;
                return;
            }
            final TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer != null && !treeViewer.getControl().isDisposed()) {
                treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!treeViewer.getControl().isDisposed()) {
                            ISelection sel = treeViewer.getSelection();
                            treeViewer.getControl().setRedraw(false);
                            treeViewer.refresh();
                            treeViewer.setSelection(CContentOutlinePage.this.updateSelection(sel));
                            treeViewer.getControl().setRedraw(true);
                        }
                    }
                });
            }
        }
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList<ICElement> newSelection = new ArrayList<ICElement>();
        if (sel instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                ICElement elem = (ICElement)iter.next();
                if (elem == null) continue;
                newSelection.add(elem);
            }
        }
        return new StructuredSelection(newSelection);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fOpenIncludeAction);
        }
        if (SearchForReferencesAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fSearchForReferencesAction);
        }
    }

    public void createControl(Composite parent) {
        this.treeViewer = new ProblemTreeViewer(parent, 770);
        this.treeViewer.addSelectionChangedListener(this);
        this.treeViewer.setContentProvider((IContentProvider)new CElementContentProvider(true, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StandardCElementLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener(this);
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.treeViewer);
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CContentOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        Control control = this.treeViewer.getControl();
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        IEditorInput editorInput = this.fEditor.getEditorInput();
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        try {
            if (editorInput instanceof IFileEditorInput) {
                IWorkingCopyManager wcManager = CUIPlugin.getDefault().getWorkingCopyManager();
                this.fInput = (WorkingCopy)wcManager.getWorkingCopy(editorInput);
            } else if (editorInput instanceof IStorageEditorInput) {
                this.fInput = new CFileElementWorkingCopy((IStorageEditorInput)editorInput, provider);
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "no Editor Input", null));
            }
            this.treeViewer.setInput(this.fInput);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e.getStatus());
            this.fInput = null;
        }
    }

    public void dispose() {
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.treeViewer);
        super.dispose();
    }

    public void setActionBars(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }
}

