/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.ErrorTickAdornmentProvider;
import org.eclipse.cdt.internal.ui.IAdornmentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementLabelProvider
extends LabelProvider {
    private ImageRegistry fImageRegistry = CUIPlugin.getDefault().getImageRegistry();
    private WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();
    private CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    private IAdornmentProvider[] fAdornmentProviders;
    private int fImageFlags;
    private int fTextFlags;

    public CElementLabelProvider() {
        this(0, 1, null);
    }

    public CElementLabelProvider(int textFlags, int imageFlags, IAdornmentProvider[] adormentProviders) {
        this.fAdornmentProviders = adormentProviders;
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
    }

    public String getText(Object element) {
        if (element instanceof ICElement) {
            String name;
            ICElement celem = (ICElement)element;
            switch (celem.getElementType()) {
                case 67: 
                case 68: 
                case 70: 
                case 71: {
                    IFunctionDeclaration fdecl = (IFunctionDeclaration)celem;
                    name = fdecl.getSignature();
                    break;
                }
                case 74: {
                    IVariable var = (IVariable)celem;
                    name = var.getTypeName() + " " + var.getElementName();
                    break;
                }
                case 69: 
                case 75: {
                    IVariableDeclaration vdecl = (IVariableDeclaration)celem;
                    name = vdecl.getTypeName() + " " + vdecl.getElementName();
                    break;
                }
                default: {
                    name = celem.getElementName();
                }
            }
            if (celem instanceof IBinary) {
                IBinary bin = (IBinary)celem;
                name = name + " - [" + bin.getCPU() + (bin.isLittleEndian() ? "le" : "be") + "]";
            }
            return name;
        }
        return this.fWorkbenchLabelProvider.getText(element);
    }

    public Image getImage(Object element) {
        Image result;
        int imageFlags = this.getImageFlags();
        if (this.fAdornmentProviders != null) {
            int i = 0;
            while (i < this.fAdornmentProviders.length) {
                imageFlags |= this.fAdornmentProviders[i].computeAdornmentFlags(element);
                ++i;
            }
        }
        if (element instanceof ICElement && (result = this.fImageLabelProvider.getImageLabel(element, imageFlags)) != null) {
            return result;
        }
        return this.fWorkbenchLabelProvider.getImage(element);
    }

    public void dispose() {
        if (this.fAdornmentProviders != null) {
            int i = 0;
            while (i < this.fAdornmentProviders.length) {
                this.fAdornmentProviders[i].dispose();
                ++i;
            }
        }
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
            this.fWorkbenchLabelProvider = null;
        }
        this.fImageRegistry = null;
        if (this.fImageLabelProvider != null) {
            this.fImageLabelProvider.dispose();
        }
    }

    public void setTextFlags(int textFlags) {
        this.fTextFlags = textFlags;
    }

    public void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public int getImageFlags() {
        return this.fImageFlags;
    }

    public int getTextFlags() {
        return this.fTextFlags;
    }

    public static IAdornmentProvider[] getAdornmentProviders(boolean errortick, IAdornmentProvider extra) {
        if (errortick) {
            if (extra == null) {
                return new IAdornmentProvider[]{new ErrorTickAdornmentProvider()};
            }
            return new IAdornmentProvider[]{new ErrorTickAdornmentProvider(), extra};
        }
        if (extra != null) {
            return new IAdornmentProvider[]{extra};
        }
        return null;
    }
}

