/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.model.internal;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.builder.BuilderPlugin;
import org.eclipse.cdt.core.builder.model.ICBuildConfig;
import org.eclipse.cdt.core.builder.model.ICBuildConfigWorkingCopy;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigInfo;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigManager;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigWorkingCopy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CBuildConfig
extends PlatformObject
implements ICBuildConfig {
    private IPath fLocation;

    protected CBuildConfig(IPath location) {
        this.setLocation(location);
    }

    protected CBuildConfig(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String localString = root.getAttribute("local");
            String path = root.getAttribute("path");
            String message = null;
            if (path == null) {
                message = DebugCoreMessages.getString((String)"LaunchConfiguration.Invalid_build_configuration_memento__missing_path_attribute_3");
            } else if (localString == null) {
                message = DebugCoreMessages.getString((String)"LaunchConfiguration.Invalid_build_configuration_memento__missing_local_attribute_4");
            }
            if (message != null) {
                IStatus s = this.newStatus(message, 5013, null);
                throw new CoreException(s);
            }
            IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path);
            this.setLocation(location);
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        IStatus s = this.newStatus(DebugCoreMessages.getString((String)"LaunchConfiguration.Exception_occurred_parsing_memento_5"), 5013, ex);
        throw new CoreException(s);
    }

    protected IStatus newStatus(String message, int code, Throwable e) {
        return new Status(4, DebugPlugin.getUniqueIdentifier(), code, message, e);
    }

    public void build(IProgressMonitor monitor) throws CoreException {
    }

    public String getName() {
        return this.getLastLocationSegment();
    }

    private String getLastLocationSegment() {
        String name = this.getLocation().lastSegment();
        name = name.substring(0, name.length() - ("build".length() + 1));
        return name;
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    private void setLocation(IPath location) {
        this.fLocation = location;
    }

    public boolean exists() {
        IFile file = this.getFile();
        if (file == null) {
            return this.getLocation().toFile().exists();
        }
        return file.exists();
    }

    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        return this.getInfo().getIntAttribute(attributeName, defaultValue);
    }

    public String getAttribute(String attributeName, String defaultValue) throws CoreException {
        return this.getInfo().getStringAttribute(attributeName, defaultValue);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        return this.getInfo().getBooleanAttribute(attributeName, defaultValue);
    }

    public List getAttribute(String attributeName, List defaultValue) throws CoreException {
        return this.getInfo().getListAttribute(attributeName, defaultValue);
    }

    public Map getAttribute(String attributeName, Map defaultValue) throws CoreException {
        return this.getInfo().getMapAttribute(attributeName, defaultValue);
    }

    public boolean isLocal() {
        return this.getFile() == null;
    }

    public ICBuildConfigWorkingCopy getWorkingCopy() throws CoreException {
        return new CBuildConfigWorkingCopy(this);
    }

    public ICBuildConfigWorkingCopy copy(String name) throws CoreException {
        CBuildConfigWorkingCopy copy = new CBuildConfigWorkingCopy(this, name);
        return copy;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void delete() throws CoreException {
        if (this.exists()) {
            if (this.isLocal()) {
                if (!this.getLocation().toFile().delete()) {
                    throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.getString((String)"LaunchConfiguration.Failed_to_delete_build_configuration._1"), null));
                }
                this.getBuildConfigurationManager().configurationDeleted(this);
            } else {
                IFile file = this.getFile();
                if (file != null) {
                    file.delete(true, null);
                }
            }
        }
    }

    protected CBuildConfigInfo getInfo() throws CoreException {
        return this.getBuildConfigurationManager().getInfo(this);
    }

    protected CBuildConfigManager getBuildConfigurationManager() {
        return BuilderPlugin.getDefault().getBuildConfigurationManager();
    }

    public String getMemento() throws CoreException {
        IPath relativePath = this.getFile().getFullPath();
        relativePath = relativePath.setDevice(null);
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement("buildConfiguration");
        doc.appendChild(node);
        node.setAttribute("local", new Boolean(this.isLocal()).toString());
        node.setAttribute("path", relativePath.toString());
        try {
            return CBuildConfigManager.serializeDocument((Document)doc);
        }
        catch (IOException e) {
            IStatus status = this.newStatus(DebugCoreMessages.getString((String)"LaunchConfiguration.Exception_occurred_creating_build_configuration_memento_9"), 5013, e);
            throw new CoreException(status);
        }
    }

    public IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.getLocation());
    }

    public IProject getProject() {
        return this.getFile().getProject();
    }

    public boolean contentsEqual(ICBuildConfig object) {
        try {
            if (object instanceof CBuildConfig) {
                CBuildConfig otherConfig = (CBuildConfig)object;
                return this.getName().equals(otherConfig.getName()) && this.getLocation().equals((Object)otherConfig.getLocation()) && this.getInfo().equals(otherConfig.getInfo());
            }
            return false;
        }
        catch (CoreException ce) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ICBuildConfig) {
            if (this.isWorkingCopy()) {
                return this == object;
            }
            ICBuildConfig config = (ICBuildConfig)object;
            if (!config.isWorkingCopy()) {
                return config.getLocation().equals((Object)this.getLocation());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    protected IContainer getContainer() {
        IFile file = this.getFile();
        if (file != null) {
            return file.getParent();
        }
        return null;
    }
}

