/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.CExtensionReference;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDescriptor
implements ICDescriptor {
    private COwner fOwner;
    private IProject fProject;
    private HashMap extMap = new HashMap(4);
    private HashMap extInfoMap = new HashMap(4);
    static final String DESCRIPTION_FILE_NAME = ".cdtproject";
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private boolean fDirty;
    private boolean autoSave;

    protected CDescriptor(IProject project, String id) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if ((descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            this.readCDTProject(descriptionPath);
            Status status = this.fOwner.getID().equals(id) ? new Status(2, "org.eclipse.cdt.core", 1, "CDTProject already exisits", (Throwable)null) : new Status(4, "org.eclipse.cdt.core", 2, "CDTProject already exisits but does not match owner ID of creator", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(id);
    }

    protected CDescriptor(IProject project) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "CDTProject file not found", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        this.readCDTProject(descriptionPath);
    }

    protected CDescriptor(IProject project, COwner owner) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "CDTProject file not found", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = owner;
        this.readProjectExtensions(this.getCDTProjectNode(descriptionPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node getCDTProjectNode(IPath descriptionPath) throws CoreException {
        FileInputStream file = null;
        try {
            try {
                file = new FileInputStream(descriptionPath.toFile());
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(file);
                Node node = document.getFirstChild();
                if (!node.getNodeName().equals(PROJECT_DESCRIPTION)) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, "Missing cdtproject element", null);
                    throw new CoreException((IStatus)status);
                }
                Node node2 = node;
                Object var9_9 = null;
                if (file == null) return node2;
                try {
                    file.close();
                    return node2;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return node2;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.cdt.core", -1, e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (file == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            file.close();
            throw throwable;
        }
    }

    protected void readCDTProject(IPath projectLocation) throws CoreException {
        Node node = this.getCDTProjectNode(projectLocation);
        this.fOwner = this.readProjectDescription(node);
    }

    protected IPath getProjectDefaultLocation(IProject project) {
        return Platform.getLocation().append(project.getFullPath());
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICExtensionReference[] get(String extensionID) {
        ICExtensionReference[] refs = (CExtensionReference[])this.extMap.get(extensionID);
        if (refs == null) {
            return new ICExtensionReference[0];
        }
        return refs;
    }

    public ICExtensionReference[] get(String extensionID, boolean update) {
        ICExtensionReference[] ext = this.get(extensionID);
        if (ext.length == 0 && update) {
            try {
                this.fOwner.update(this.fProject, this, extensionID);
                this.saveInfo();
                ext = this.get(extensionID);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return ext;
    }

    public ICExtensionReference create(String extensionPoint, String extensionID) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
        if (extensions == null) {
            extensions = new CExtensionReference[1];
            this.extMap.put(extensionPoint, extensions);
        } else {
            CExtensionReference[] newExtensions = new CExtensionReference[extensions.length + 1];
            System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
            extensions = newExtensions;
            this.extMap.put(extensionPoint, extensions);
        }
        extensions[extensions.length - 1] = new CExtensionReference(this, extensionPoint, extensionID);
        this.setDirty();
        return extensions[extensions.length - 1];
    }

    public void remove(ICExtensionReference ext) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(ext.getExtension());
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i] == ext) {
                System.arraycopy(extensions, i, extensions, i + 1, extensions.length - 1 - i);
                CExtensionReference[] newExtensions = new CExtensionReference[extensions.length - 1];
                System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
                extensions = newExtensions;
                if (extensions.length == 0) {
                    this.extMap.put(ext.getExtension(), null);
                } else {
                    this.extMap.put(ext.getExtension(), extensions);
                }
                this.setDirty();
            }
            ++i;
        }
    }

    public void remove(String extensionPoint) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
        if (extensions != null) {
            this.extMap.remove(extensionPoint);
            this.setDirty();
        }
    }

    public CExtensionInfo getInfo(CExtensionReference cProjectExtension) {
        CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(cProjectExtension);
        if (info == null) {
            info = new CExtensionInfo();
            this.extInfoMap.put(cProjectExtension, info);
        }
        return info;
    }

    protected Node searchNode(Node target, String tagName) {
        NodeList list = target.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(tagName)) {
                return list.item(i);
            }
            ++i;
        }
        return null;
    }

    protected String getString(Node target, String tagName) {
        Node node = this.searchNode(target, tagName);
        return node != null ? (node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue()) : null;
    }

    private COwner readProjectDescription(Node node) throws CoreException {
        COwner owner = null;
        NamedNodeMap attrib = node.getAttributes();
        owner = new COwner(attrib.getNamedItem("id").getNodeValue());
        this.readProjectExtensions(node);
        return owner;
    }

    private void readProjectExtensions(Node node) throws CoreException {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(PROJECT_EXTENSION)) {
                NamedNodeMap attrib = list.item(i).getAttributes();
                ICExtensionReference ext = this.create(attrib.getNamedItem("point").getNodeValue(), attrib.getNamedItem("id").getNodeValue());
                NodeList extAttrib = list.item(i).getChildNodes();
                int j = 0;
                while (j < extAttrib.getLength()) {
                    if (extAttrib.item(j).getNodeName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                        attrib = extAttrib.item(j).getAttributes();
                        ext.setExtensionData(attrib.getNamedItem("key").getNodeValue(), attrib.getNamedItem("value").getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void saveInfo() throws CoreException {
        String xml;
        if (!this.isDirty()) {
            return;
        }
        try {
            xml = this.getAsXML();
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        IFile rscFile = this.getProject().getFile(DESCRIPTION_FILE_NAME);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        if (rscFile.exists()) {
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
        this.fDirty = false;
    }

    protected void setDirty() throws CoreException {
        this.fDirty = true;
        if (this.isAutoSave()) {
            this.saveInfo();
        }
    }

    protected boolean isDirty() {
        return this.fDirty;
    }

    protected String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }

    protected String getAsXML() throws IOException {
        DocumentImpl doc = new DocumentImpl();
        Element configRootElement = doc.createElement(PROJECT_DESCRIPTION);
        doc.appendChild(configRootElement);
        configRootElement.setAttribute("id", this.fOwner.getID());
        Iterator extIterator = this.extMap.values().iterator();
        while (extIterator.hasNext()) {
            CExtensionReference[] extension = (CExtensionReference[])extIterator.next();
            int i = 0;
            while (i < extension.length) {
                Element element = doc.createElement(PROJECT_EXTENSION);
                configRootElement.appendChild(element);
                element.setAttribute("point", extension[i].getExtension());
                element.setAttribute("id", extension[i].getID());
                CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(extension[i]);
                if (info != null) {
                    Iterator attribIterator = info.getAttributes().entrySet().iterator();
                    while (attribIterator.hasNext()) {
                        Map.Entry entry = attribIterator.next();
                        Element extAttributes = doc.createElement(PROJECT_EXTENSION_ATTRIBUTE);
                        extAttributes.setAttribute("key", (String)entry.getKey());
                        extAttributes.setAttribute("value", (String)entry.getValue());
                        element.appendChild(extAttributes);
                    }
                }
                ++i;
            }
        }
        return this.serializeDocument((Document)doc);
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    protected ICExtension createExtensions(ICExtensionReference ext) throws CoreException {
        InternalCExtension cExtension = null;
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(ext.getExtension());
        IExtension extension = extensionPoint.getExtension(ext.getID());
        IConfigurationElement[] element = extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase("cextension")) {
                cExtension = (InternalCExtension)element[i].createExecutableExtension("run");
                cExtension.setExtenionReference(ext);
                cExtension.setProject(this.fProject);
                break;
            }
            ++i;
        }
        return (ICExtension)((Object)cExtension);
    }
}

