/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

class BinaryInfo
extends OpenableInfo {
    int type;
    boolean debug;
    String cpu = "";
    String[] shared = new String[0];
    long text;
    long data;
    long bss;
    String soname = "";
    boolean littleE;

    public BinaryInfo(CElement element) {
        super(element);
    }

    public String getCPU() {
        return this.cpu;
    }

    public boolean isSharedLib() {
        return this.type == 4;
    }

    public boolean isExecutable() {
        return this.type == 2;
    }

    public boolean isObject() {
        return this.type == 1;
    }

    public boolean isCore() {
        return this.type == 16;
    }

    public boolean hasDebug() {
        return this.debug;
    }

    public String[] getNeededSharedLibs() {
        return this.shared;
    }

    public long getText() {
        return this.text;
    }

    public long getData() {
        return this.data;
    }

    public long getBSS() {
        return this.bss;
    }

    public String getSoname() {
        return this.soname;
    }

    public boolean isLittleEndian() {
        return this.littleE;
    }

    protected void loadInfo() {
        this.loadInfo(this.getBinaryObject());
    }

    protected void loadInfo(IBinaryParser.IBinaryObject bin) {
        if (bin != null) {
            this.type = bin.getType();
            this.cpu = bin.getCPU();
            this.debug = bin.hasDebug();
            if (this.isExecutable()) {
                IBinaryParser.IBinaryExecutable exec = (IBinaryParser.IBinaryExecutable)bin;
                this.shared = exec.getNeededSharedLibs();
            }
            this.text = bin.getText();
            this.data = bin.getData();
            this.bss = bin.getBSS();
            if (this.isSharedLib()) {
                IBinaryParser.IBinaryShared shared = (IBinaryParser.IBinaryShared)bin;
                this.soname = shared.getSoName();
            }
            this.littleE = bin.isLittleEndian();
        }
    }

    private IBinaryParser.IBinaryObject getBinaryObject() {
        IBinaryParser.IBinaryObject binary = null;
        IProject project = this.getElement().getCProject().getProject();
        IBinaryParser parser = CModelManager.getDefault().getBinaryParser(project);
        if (parser != null) {
            try {
                IPath path = this.getElement().getUnderlyingResource().getLocation();
                IBinaryParser.IBinaryFile bfile = parser.getBinary(path);
                if (bfile instanceof IBinaryParser.IBinaryObject) {
                    binary = (IBinaryParser.IBinaryObject)bfile;
                }
            }
            catch (CModelException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return binary;
    }
}

