/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CContainer
extends Openable
implements ICContainer {
    public CContainer(ICElement parent, IResource res) {
        this(parent, res, 12);
    }

    public CContainer(ICElement parent, IResource res, int type) {
        super(parent, res, type);
    }

    public IBinary[] getBinaries() throws CModelException {
        ArrayList list = this.getChildrenOfType(14);
        IBinary[] array = new IBinary[list.size()];
        list.toArray(array);
        return array;
    }

    public IArchive[] getArchives() throws CModelException {
        ArrayList list = this.getChildrenOfType(18);
        IArchive[] array = new IArchive[list.size()];
        list.toArray(array);
        return array;
    }

    public ITranslationUnit[] getTranslationUnit() throws CModelException {
        ArrayList list = this.getChildrenOfType(60);
        ITranslationUnit[] array = new ITranslationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    protected CElementInfo createElementInfo() {
        return new CContainerInfo(this);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        boolean validInfo = false;
        try {
            IResource res = this.getResource();
            if (res != null && (res instanceof IWorkspaceRoot || res.getProject().isOpen())) {
                CModelManager.getDefault().putInfo(this, info);
                validInfo = this.computeChildren(info, res);
            }
            Object var8_7 = null;
            if (!validInfo) {
                CModelManager.getDefault().removeInfo(this);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!validInfo) {
                CModelManager.getDefault().removeInfo(this);
            }
            throw throwable;
        }
        return validInfo;
    }

    public Object[] getNonCResources() throws CModelException {
        return ((CContainerInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) {
        ArrayList<ICElement> vChildren = new ArrayList<ICElement>();
        ArrayList<IResource> notChildren = new ArrayList<IResource>();
        try {
            IResource[] resources = null;
            if (res != null) {
                switch (res.getType()) {
                    case 2: 
                    case 4: 
                    case 8: {
                        IContainer container = (IContainer)res;
                        resources = container.members(false);
                        break;
                    }
                }
            }
            if (resources != null) {
                CModelManager factory = CModelManager.getDefault();
                int i = 0;
                while (i < resources.length) {
                    ICElement celement = factory.create((ICElement)this, resources[i]);
                    if (celement != null) {
                        vChildren.add(celement);
                    } else {
                        notChildren.add(resources[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ICElement[] children = new ICElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        ((CContainerInfo)this.getElementInfo()).setNonCResources(notChildren.toArray());
        return true;
    }
}

