/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Util;

public class FunctionDeclaration
extends SourceManipulation
implements IFunctionDeclaration {
    protected static final String[] fgEmptyList = new String[0];
    protected String[] fParameterTypes = fgEmptyList;
    protected String returnType;

    public FunctionDeclaration(ICElement parent, String name) {
        super(parent, name, 70);
    }

    public FunctionDeclaration(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    public String getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        return "";
    }

    public void setReturnType(String type) {
        this.returnType = type;
        this.getFunctionInfo().setReturnType(type);
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.fParameterTypes = parameterTypes;
    }

    public String getSignature() {
        String sig = this.getReturnType();
        sig = sig + " ";
        sig = sig + this.getElementName();
        if (this.getNumberOfParameters() > 0) {
            sig = sig + "(";
            String[] paramTypes = this.getParameterTypes();
            int i = 0;
            sig = sig + paramTypes[i++];
            while (i < paramTypes.length) {
                sig = sig + ", ";
                sig = sig + paramTypes[i++];
            }
            sig = sig + ")";
        } else {
            sig = sig + "()";
        }
        return sig;
    }

    public String getParameterInitializer(int pos) {
        return "";
    }

    public int getAccessControl() {
        return this.getFunctionInfo().getAccessControl();
    }

    public String[] getExceptions() {
        return new String[0];
    }

    protected CElementInfo createElementInfo() {
        return new FunctionInfo(this);
    }

    protected FunctionInfo getFunctionInfo() {
        return (FunctionInfo)this.getElementInfo();
    }

    public boolean equals(Object other) {
        return super.equals(other) && Util.equalArraysOrNull(this.fParameterTypes, ((FunctionDeclaration)other).fParameterTypes) && this.getReturnType().equals(((FunctionDeclaration)other).getReturnType());
    }
}

