/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.ModelBuilder;
import org.eclipse.cdt.internal.core.model.NewModelBuilder;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.parser.CStructurizer;
import org.eclipse.core.runtime.IPath;

class TranslationUnitInfo
extends OpenableInfo {
    protected long fTimestamp;

    protected TranslationUnitInfo(CElement element) {
        super(element);
    }

    protected boolean hasChildren() {
        return true;
    }

    protected ICElement[] getChildren() {
        return this.fChildren;
    }

    protected void parse(InputStream in) {
        try {
            this.removeChildren();
            if (CCorePlugin.getDefault().useNewParser()) {
                NewModelBuilder modelBuilder = new NewModelBuilder((TranslationUnit)this.getElement());
                Parser parser = new Parser(in, (IParserCallback)modelBuilder, true);
                parser.parse();
            } else {
                ModelBuilder modelBuilder = new ModelBuilder((TranslationUnit)this.getElement());
                CStructurizer.getCStructurizer().parse(modelBuilder, in);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void parse(String buf) {
        if (buf != null) {
            StringBufferInputStream in = new StringBufferInputStream(buf);
            this.parse(in);
        }
    }

    protected ISourceRange getSourceRange() {
        IPath location = ((TranslationUnit)this.getElement()).getLocation();
        return new SourceRange(0, (int)location.toFile().length());
    }
}

