/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.ElfBinaryFile;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class ElfBinaryArchive
extends PlatformObject
implements IBinaryParser.IBinaryArchive {
    IPath path;
    ArrayList children;
    long timestamp;

    public ElfBinaryArchive(IPath p) {
        this.path = p;
        this.children = new ArrayList(5);
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            if (this.path != null) {
                AR ar = null;
                try {
                    ar = new AR(this.path.toOSString());
                    AR.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        ElfBinaryFile bin = new ElfBinaryFile(this.path, headers[i]);
                        this.children.add(bin);
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ar != null) {
                    ar.dispose();
                }
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    public IPath getPath() {
        return this.path;
    }

    public int getType() {
        return 8;
    }

    public InputStream getContents() {
        try {
            return new FileInputStream(this.path.toFile());
        }
        catch (IOException iOException) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    boolean hasChanged() {
        long modif = this.path.toFile().lastModified();
        boolean changed = modif != this.timestamp;
        this.timestamp = modif;
        return changed;
    }

    public void add(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }

    public void delete(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }
}

