/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.PEBinaryFile;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class PEBinaryArchive
extends PlatformObject
implements IBinaryParser.IBinaryArchive {
    IPath path;
    ArrayList children;
    long timestamp;

    public PEBinaryArchive(IPath p) {
        this.path = p;
        this.children = new ArrayList(5);
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            if (this.path != null) {
                PEArchive ar = null;
                try {
                    ar = new PEArchive(this.path.toOSString());
                    PEArchive.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        PEBinaryFile bin = new PEBinaryFile(this.path, headers[i].getObjectName());
                        this.children.add(bin);
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ar != null) {
                    ar.dispose();
                }
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    public IPath getPath() {
        return this.path;
    }

    public int getType() {
        return 8;
    }

    public InputStream getContents() {
        try {
            return new FileInputStream(this.path.toFile());
        }
        catch (IOException iOException) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    boolean hasChanged() {
        File file = this.path.toFile();
        if (file != null && file.exists()) {
            long modification = file.lastModified();
            boolean changed = modification != this.timestamp;
            this.timestamp = modification;
            return changed;
        }
        return false;
    }

    public void add(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }

    public void delete(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }
}

