/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.internal.core.parser.Declaration;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.util.TypeInfo;

public class ParserSymbolTable {
    private Stack _contextStack = new Stack();
    private Declaration _compilationUnit = new Declaration();
    static /* synthetic */ Class class$org$eclipse$cdt$internal$core$parser$Declaration;
    static /* synthetic */ Class class$java$util$LinkedList;

    public ParserSymbolTable() {
        try {
            this._compilationUnit.setType(1);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            // empty catch block
        }
        this.push(this._compilationUnit);
    }

    public void push(Declaration obj) {
        if (!this._contextStack.empty() && obj.getContainingScope() == null) {
            obj.setContainingScope((Declaration)this._contextStack.peek());
        }
        this._contextStack.push(obj);
    }

    public Declaration pop() {
        return (Declaration)this._contextStack.pop();
    }

    public Declaration peek() {
        return (Declaration)this._contextStack.peek();
    }

    public Declaration getCompilationUnit() {
        return this._compilationUnit;
    }

    public Declaration Lookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration ElaboratedLookup(int type, String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, type);
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration LookupNestedNameSpecifier(String name) throws ParserSymbolTableException {
        return this.LookupNestedNameSpecifier(name, (Declaration)this._contextStack.peek());
    }

    private Declaration LookupNestedNameSpecifier(String name, Declaration inDeclaration) throws ParserSymbolTableException {
        Declaration foundDeclaration = null;
        LookupData data = new LookupData(name, 1);
        data.upperType = 4;
        foundDeclaration = ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (foundDeclaration == null && inDeclaration._containingScope != null) {
            foundDeclaration = this.LookupNestedNameSpecifier(name, inDeclaration._containingScope);
        }
        return foundDeclaration;
    }

    public Declaration LookupMemberForDefinition(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        data.qualified = true;
        return ParserSymbolTable.LookupInContained(data, (Declaration)this._contextStack.peek());
    }

    public Declaration QualifiedLookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        data.qualified = true;
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration QualifiedFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, 6);
        data.qualified = true;
        data.parameters = parameters;
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration MemberFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, 6);
        data.parameters = parameters;
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration UnqualifiedFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        HashSet associated = new HashSet();
        int size = parameters == null ? 0 : parameters.size();
        Iterator iter = parameters == null ? null : parameters.iterator();
        TypeInfo param = null;
        Declaration paramType = null;
        int i = size;
        while (i > 0) {
            param = (TypeInfo)iter.next();
            paramType = param.getTypeDeclaration();
            ParserSymbolTable.getAssociatedScopes(paramType, associated);
            if (param.getPtrOperator() != null && (param.getPtrOperator().equals("*") || param.getPtrOperator().equals("[]")) && paramType._containingScope.isType(2, 4)) {
                ParserSymbolTable.getAssociatedScopes(paramType._containingScope, associated);
            }
            --i;
        }
        LookupData data = new LookupData(name, 6);
        data.parameters = parameters;
        data.associated = associated;
        Declaration found = ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        if (found == null || found._containingScope.getType() != 2) {
            HashSet<Declaration> foundSet = new HashSet<Declaration>();
            if (found != null) {
                foundSet.add(found);
            }
            Object[] scopes = ((AbstractCollection)associated).toArray();
            size = associated.size();
            int i2 = 0;
            while (i2 < size) {
                Declaration decl = (Declaration)scopes[i2];
                if (associated.contains(decl)) {
                    data.qualified = true;
                    data.ignoreUsingDirectives = true;
                    Declaration temp = ParserSymbolTable.Lookup(data, decl);
                    if (temp != null) {
                        foundSet.add(temp);
                    }
                }
                ++i2;
            }
            found = ParserSymbolTable.ResolveAmbiguities(data, foundSet);
        }
        return found;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private Declaration LookupForFriendship(String name) throws ParserSymbolTableException {
        boolean bl;
        LookupData data = new LookupData(name, -1);
        Declaration decl = (Declaration)this._contextStack.peek();
        boolean inClass = decl.getType() == 2;
        Declaration enclosing = decl._containingScope;
        boolean bl2 = true;
        do {
            if (!bl2 || (bl2 = false) || !true) {
                enclosing = enclosing._containingScope;
            }
            if (enclosing == null) break;
            if (inClass) {
                if (enclosing.getType() != 2) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = enclosing.getType() == 1;
        } while (bl);
        data.stopAt = enclosing;
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public void addUsingDirective(Declaration namespace) throws ParserSymbolTableException {
        if (namespace.getType() != 1) {
            throw new ParserSymbolTableException(1);
        }
        Declaration declaration = (Declaration)this._contextStack.peek();
        if (declaration._usingDirectives == null) {
            declaration._usingDirectives = new LinkedList();
        }
        declaration._usingDirectives.add(namespace);
    }

    public Declaration addUsingDeclaration(Declaration obj) throws ParserSymbolTableException {
        Declaration clone = null;
        Declaration context = (Declaration)this._contextStack.peek();
        boolean okToAdd = false;
        if (context.isType(2, 4)) {
            if (obj.getContainingScope().getType() == context.getType()) {
                okToAdd = ParserSymbolTable.hasBaseClass(context, obj.getContainingScope()) > 0;
            } else if (obj.getContainingScope().getType() == 4) {
                Declaration union = obj.getContainingScope();
                okToAdd = ParserSymbolTable.hasBaseClass(context, union.getContainingScope()) > 0;
            } else if (obj.getType() == 14) {
                Declaration enumeration = obj.getContainingScope();
                okToAdd = ParserSymbolTable.hasBaseClass(context, enumeration.getContainingScope()) > 0;
            }
        } else {
            okToAdd = true;
        }
        if (!okToAdd) {
            throw new ParserSymbolTableException();
        }
        clone = (Declaration)obj.clone();
        this.addDeclaration(clone);
        return clone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDeclaration(Declaration obj) throws ParserSymbolTableException {
        Declaration containing = (Declaration)this._contextStack.peek();
        if (obj.getType() == 14 && containing.getType() == 5) {
            obj.setTypeDeclaration(containing);
            containing = containing.getContainingScope();
        }
        Map declarations = containing.getContainedDeclarations();
        boolean unnamed = obj.getName().equals("");
        Object origObj = null;
        obj.setContainingScope(containing);
        if (declarations == null) {
            declarations = containing.createContained();
        } else {
            origObj = declarations.get(obj.getName());
        }
        if (origObj != null) {
            Declaration origDecl = null;
            LinkedList<Declaration> origList = null;
            if (origObj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
                origDecl = (Declaration)origObj;
            } else {
                if (origObj.getClass() != (class$java$util$LinkedList == null ? (class$java$util$LinkedList = ParserSymbolTable.class$("java.util.LinkedList")) : class$java$util$LinkedList)) throw new ParserSymbolTableException();
                origList = (LinkedList<Declaration>)origObj;
            }
            if (!(unnamed || origList == null ? ParserSymbolTable.isValidOverload(origDecl, obj) : ParserSymbolTable.isValidOverload(origList, obj))) throw new ParserSymbolTableException(3);
            if (origList == null) {
                origList = new LinkedList<Declaration>();
                origList.add(origDecl);
                origList.add(obj);
                declarations.remove(obj);
                declarations.put(obj.getName(), origList);
            } else {
                origList.add(obj);
            }
        } else {
            declarations.put(obj.getName(), obj);
        }
        TypeInfo type = obj._typeInfo;
        if (!type.isType(6) || type.checkBit(128)) return;
        this.addThis(obj);
    }

    public Declaration addFriend(String name) throws ParserSymbolTableException {
        Declaration friend = this.LookupForFriendship(name);
        if (friend == null) {
            friend = new Declaration(name);
            friend.setNeedsDefinition(true);
            Declaration decl = (Declaration)this._contextStack.peek();
            Declaration containing = decl._containingScope;
            while (containing != null && containing.getType() != 1) {
                containing = containing._containingScope;
            }
            Declaration namespace = containing == null ? this._compilationUnit : containing;
            this.push(namespace);
            this.addDeclaration(friend);
            this.pop();
        }
        return friend;
    }

    private void addThis(Declaration obj) throws ParserSymbolTableException {
        LookupData data;
        TypeInfo type = obj._typeInfo;
        if (!type.isType(6) || type.checkBit(128)) {
            return;
        }
        if (obj._containingScope.isType(2, 4) && ParserSymbolTable.LookupInContained(data = new LookupData("this", -1), obj) == null) {
            Declaration thisObj = new Declaration("this");
            thisObj.setType(0);
            thisObj.setTypeDeclaration(obj._containingScope);
            thisObj.setCVQualifier(obj.getCVQualifier());
            thisObj.setPtrOperator("*");
            this.push(obj);
            this.addDeclaration(thisObj);
            this.pop();
        }
    }

    private static Declaration Lookup(LookupData data, Declaration inDeclaration) throws ParserSymbolTableException {
        if (data.type != -1 && data.type < 2 && data.upperType > 4) {
            throw new ParserSymbolTableException(1);
        }
        Declaration decl = null;
        LinkedList tempList = null;
        LinkedList<Declaration> foundNames = new LinkedList<Declaration>();
        LinkedList transitives = new LinkedList();
        decl = ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (decl != null) {
            foundNames.add(decl);
        }
        if (!data.ignoreUsingDirectives) {
            data.visited.clear();
            tempList = ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
            if (tempList != null) {
                foundNames.addAll(tempList);
            }
            if (!data.qualified || foundNames.size() == 0) {
                ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
                if (inDeclaration._usingDirectives != null) {
                    ParserSymbolTable.ProcessDirectives(inDeclaration, data, inDeclaration._usingDirectives);
                }
                while (data.usingDirectives != null && data.usingDirectives.get(inDeclaration) != null) {
                    transitives.clear();
                    tempList = ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
                    if (tempList != null) {
                        foundNames.addAll(tempList);
                    }
                    if (data.qualified && foundNames.size() != 0) continue;
                    ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
                }
            }
        }
        if ((decl = ParserSymbolTable.ResolveAmbiguities(data, new HashSet(foundNames))) != null || data.stopAt == inDeclaration) {
            return decl;
        }
        data.visited.clear();
        decl = ParserSymbolTable.LookupInParents(data, inDeclaration);
        if (decl == null && inDeclaration._containingScope != null) {
            decl = ParserSymbolTable.Lookup(data, inDeclaration._containingScope);
        }
        return decl;
    }

    private static LinkedList LookupInNominated(LookupData data, Declaration declaration, LinkedList transitiveDirectives) throws ParserSymbolTableException {
        if (data.usingDirectives == null) {
            return null;
        }
        LinkedList<Declaration> found = null;
        LinkedList list = null;
        Iterator iter = null;
        Declaration decl = null;
        Declaration temp = null;
        int size = 0;
        list = (LinkedList)data.usingDirectives.remove(declaration);
        if (list == null) {
            return null;
        }
        iter = list.iterator();
        int i = size = list.size();
        while (i > 0) {
            decl = (Declaration)iter.next();
            if (!data.visited.contains(decl)) {
                data.visited.add(decl);
                temp = ParserSymbolTable.LookupInContained(data, decl);
                if (temp != null) {
                    if (found == null) {
                        found = new LinkedList<Declaration>();
                    }
                    found.add(temp);
                }
                if (!(data.qualified && temp != null || decl._usingDirectives == null)) {
                    transitiveDirectives.addAll(decl._usingDirectives);
                }
            }
            --i;
        }
        return found;
    }

    private static Declaration LookupInContained(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        Map declarations;
        HashSet<Declaration> found = null;
        Declaration temp = null;
        Object obj = null;
        if (data.associated != null) {
            data.associated.remove(lookIn);
        }
        if ((declarations = lookIn.getContainedDeclarations()) == null) {
            return null;
        }
        obj = declarations.get(data.name);
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
            if (((Declaration)obj).isType(data.type, data.upperType)) {
                return (Declaration)obj;
            }
        } else {
            found = new HashSet<Declaration>();
            LinkedList objList = (LinkedList)obj;
            Iterator iter = objList.iterator();
            int size = objList.size();
            int i = 0;
            while (i < size) {
                temp = (Declaration)iter.next();
                if (temp.isType(data.type, data.upperType)) {
                    found.add(temp);
                }
                ++i;
            }
        }
        if (found == null || found.size() == 0) {
            return null;
        }
        return ParserSymbolTable.ResolveAmbiguities(data, found);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Declaration LookupInParents(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        int size;
        LinkedList scopes = lookIn.getParentScopes();
        Declaration temp = null;
        Declaration decl = null;
        Iterator iterator = null;
        Declaration.ParentWrapper wrapper = null;
        if (scopes == null) {
            return null;
        }
        if (data.inheritanceChain == null) {
            data.inheritanceChain = new HashSet();
        }
        data.inheritanceChain.add(lookIn);
        iterator = scopes.iterator();
        int i = size = scopes.size();
        while (i > 0) {
            wrapper = (Declaration.ParentWrapper)iterator.next();
            if (!wrapper.isVirtual || !data.visited.contains(wrapper.parent)) {
                if (wrapper.isVirtual) {
                    data.visited.add(wrapper.parent);
                }
                if (!data.inheritanceChain.add(wrapper.parent)) throw new ParserSymbolTableException(2);
                temp = ParserSymbolTable.LookupInContained(data, wrapper.parent);
                if (temp == null) {
                    temp = ParserSymbolTable.LookupInParents(data, wrapper.parent);
                }
                data.inheritanceChain.remove(wrapper.parent);
            }
            if (temp != null && temp.isType(data.type)) {
                if (decl == null) {
                    decl = temp;
                } else if (temp != null) {
                    TypeInfo type = temp._typeInfo;
                    if (decl != temp || !type.checkBit(128) && !type.isType(14)) throw new ParserSymbolTableException(0);
                    temp = null;
                }
            } else {
                temp = null;
            }
            --i;
        }
        return decl;
    }

    private static boolean isValidOverload(Declaration origDecl, Declaration newDecl) {
        int origType = origDecl.getType();
        int newType = newDecl.getType();
        if (origType >= 2 && origType <= 5 && (newType == 0 || newType >= 6 && newType <= 31)) {
            return true;
        }
        return ParserSymbolTable.isValidFunctionOverload(origDecl, newDecl);
    }

    private static boolean isValidOverload(LinkedList origList, Declaration newDecl) {
        if (origList.size() == 1) {
            return ParserSymbolTable.isValidOverload((Declaration)origList.getFirst(), newDecl);
        }
        if (origList.size() > 1) {
            if (newDecl.getType() != 6) {
                return false;
            }
            Iterator iter = origList.iterator();
            Declaration decl = (Declaration)iter.next();
            boolean valid = decl.getType() >= 2 && decl.getType() <= 5 || ParserSymbolTable.isValidFunctionOverload(decl, newDecl);
            while (valid && iter.hasNext()) {
                decl = (Declaration)iter.next();
                valid = ParserSymbolTable.isValidFunctionOverload(decl, newDecl);
            }
            return valid;
        }
        return true;
    }

    private static boolean isValidFunctionOverload(Declaration origDecl, Declaration newDecl) {
        if (origDecl.getType() != 6 || newDecl.getType() != 6) {
            return false;
        }
        if (origDecl.hasSameParameters(newDecl)) {
            if (origDecl._typeInfo.checkBit(128) || newDecl._typeInfo.checkBit(128)) {
                return false;
            }
            return origDecl.getCVQualifier() != newDecl.getCVQualifier();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Declaration ResolveAmbiguities(LookupData data, HashSet items) throws ParserSymbolTableException {
        int size = items.size();
        Iterator iter = items.iterator();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (Declaration)iter.next();
        }
        LinkedList<Declaration> functionList = null;
        Declaration decl = null;
        Declaration obj = null;
        Declaration cls = null;
        int i = size;
        while (i > 0) {
            decl = (Declaration)iter.next();
            if (decl.isType(6)) {
                if (functionList == null) {
                    functionList = new LinkedList<Declaration>();
                }
                functionList.add(decl);
            } else if (decl.isType(2, 5)) {
                if (cls != null) throw new ParserSymbolTableException(0);
                cls = decl;
            } else {
                if (obj != null) throw new ParserSymbolTableException(0);
                obj = decl;
            }
            --i;
        }
        int numFunctions = functionList == null ? 0 : functionList.size();
        boolean ambiguous = false;
        if (cls != null) {
            if (obj != null && cls._containingScope != obj._containingScope) {
                ambiguous = true;
            }
            if (functionList != null) {
                Iterator fnIter = functionList.iterator();
                Declaration fn = null;
                int i2 = numFunctions;
                while (i2 > 0) {
                    fn = (Declaration)fnIter.next();
                    if (cls._containingScope != fn._containingScope) {
                        ambiguous = true;
                        break;
                    }
                    --i2;
                }
            }
        }
        if (obj != null && !ambiguous) {
            if (numFunctions <= 0) return obj;
            ambiguous = true;
        } else if (numFunctions > 0) {
            return ParserSymbolTable.ResolveFunction(data, functionList);
        }
        if (!ambiguous) return cls;
        throw new ParserSymbolTableException(0);
    }

    private static Declaration ResolveFunction(LookupData data, LinkedList functions) throws ParserSymbolTableException {
        ParserSymbolTable.ReduceToViable(data, functions);
        int numSourceParams = data.parameters == null ? 0 : data.parameters.size();
        int numFns = functions.size();
        if (numSourceParams == 0) {
            if (numFns == 0) {
                return null;
            }
            if (numFns == 1) {
                return (Declaration)functions.getFirst();
            }
            throw new ParserSymbolTableException(0);
        }
        Declaration bestFn = null;
        Declaration currFn = null;
        int[] bestFnCost = null;
        int[] currFnCost = null;
        Iterator iterFns = functions.iterator();
        Iterator sourceParams = null;
        Iterator targetParams = null;
        int numTargetParams = 0;
        int numParams = 0;
        TypeInfo source = null;
        TypeInfo target = null;
        int i = numFns;
        while (i > 0) {
            currFn = (Declaration)iterFns.next();
            sourceParams = data.parameters.iterator();
            targetParams = currFn._parameters.iterator();
            numTargetParams = currFn._parameters.size();
            int n = numParams = numTargetParams < numSourceParams ? numTargetParams : numSourceParams;
            if (currFnCost == null) {
                currFnCost = new int[numParams];
            }
            int comparison = 0;
            int j = 0;
            while (j < numParams) {
                int temp;
                source = (TypeInfo)sourceParams.next();
                int cost = source.equals(target = (TypeInfo)targetParams.next()) ? 0 : (!ParserSymbolTable.canDoQualificationConversion(source, target) ? -1 : ((temp = ParserSymbolTable.canPromote(source, target)) >= 0 ? temp : ((temp = ParserSymbolTable.canConvert(source, target)) >= 0 ? temp : -1)));
                currFnCost[j] = cost;
                if (cost >= 0) {
                    if (bestFnCost != null) {
                        if (cost < bestFnCost[j]) {
                            comparison = 1;
                        } else if (cost > bestFnCost[j]) {
                            comparison = -1;
                            break;
                        }
                    } else {
                        comparison = 1;
                    }
                } else {
                    comparison = -1;
                }
                ++j;
            }
            if (comparison > 0) {
                bestFnCost = currFnCost;
                currFnCost = null;
                bestFn = currFn;
            } else if (comparison == 0) {
                bestFn = null;
            }
            --i;
        }
        return bestFn;
    }

    private static void ReduceToViable(LookupData data, LinkedList functions) {
        int numParameters = data.parameters == null ? 0 : data.parameters.size();
        Iterator iter = functions.iterator();
        block0: while (iter.hasNext()) {
            int num;
            Declaration function = (Declaration)iter.next();
            int n = num = function._parameters == null ? 0 : function._parameters.size();
            if (num == numParameters) continue;
            if (num < numParameters) {
                iter.remove();
                continue;
            }
            ListIterator listIter = function._parameters.listIterator(num);
            int i = num;
            while (i > numParameters - num + 1) {
                TypeInfo param = (TypeInfo)listIter.previous();
                if (!param.getHasDefault()) {
                    iter.remove();
                    continue block0;
                }
                --i;
            }
        }
    }

    private static void ProcessDirectives(Declaration decl, LookupData data, LinkedList directives) {
        Declaration enclosing = null;
        Declaration temp = null;
        int size = directives.size();
        Iterator iter = directives.iterator();
        int i = size;
        while (i > 0) {
            temp = (Declaration)iter.next();
            if (!data.visited.contains(temp)) {
                LinkedList<Declaration> list;
                enclosing = ParserSymbolTable.getClosestEnclosingDeclaration(decl, temp);
                LinkedList<Declaration> linkedList = list = data.usingDirectives == null ? null : (LinkedList<Declaration>)data.usingDirectives.get(enclosing);
                if (list == null) {
                    list = new LinkedList<Declaration>();
                    list.add(temp);
                    if (data.usingDirectives == null) {
                        data.usingDirectives = new HashMap();
                    }
                    data.usingDirectives.put(enclosing, list);
                } else {
                    list.add(temp);
                }
            }
            --i;
        }
    }

    private static Declaration getClosestEnclosingDeclaration(Declaration decl1, Declaration decl2) {
        if (decl1 == decl2) {
            return decl1;
        }
        if (decl1._depth == decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2._containingScope);
        }
        if (decl1._depth > decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(decl1, decl2._containingScope);
    }

    private static int hasBaseClass(Declaration obj, Declaration base) {
        if (obj == base) {
            return 0;
        }
        if (obj._parentScopes != null) {
            int size;
            Iterator iter = obj._parentScopes.iterator();
            int i = size = obj._parentScopes.size();
            while (i > 0) {
                Declaration.ParentWrapper wrapper = (Declaration.ParentWrapper)iter.next();
                Declaration decl = wrapper.parent;
                if (decl == base) {
                    return 1;
                }
                int n = ParserSymbolTable.hasBaseClass(decl, base);
                if (n > 0) {
                    return n + 1;
                }
                --i;
            }
        }
        return -1;
    }

    private static void getAssociatedScopes(Declaration decl, HashSet associated) {
        if (decl == null) {
            return;
        }
        if (decl.getType() == 2) {
            associated.add(decl);
            ParserSymbolTable.getBaseClassesAndContainingNamespaces(decl, associated);
        } else if (decl.getType() == 4 || decl.getType() == 5) {
            associated.add(decl._containingScope);
        }
    }

    private static void getBaseClassesAndContainingNamespaces(Declaration obj, HashSet classes) {
        if (obj._parentScopes != null) {
            int size;
            if (classes == null) {
                return;
            }
            Iterator iter = obj._parentScopes.iterator();
            int i = size = obj._parentScopes.size();
            while (i > 0) {
                Declaration.ParentWrapper wrapper = (Declaration.ParentWrapper)iter.next();
                Declaration base = wrapper.parent;
                classes.add(base);
                if (base._containingScope.getType() == 1) {
                    classes.add(base._containingScope);
                }
                ParserSymbolTable.getBaseClassesAndContainingNamespaces(base, classes);
                --i;
            }
        }
    }

    private static int canPromote(TypeInfo source, TypeInfo target) {
        if ((source.isType(7, 12) || source.isType(5)) && source.getType() == target.getType()) {
            return 0;
        }
        if (source.isType(5) || source.isType(7, 10) ? target.isType(10) && target.canHold(source) : source.isType(11) && target.isType(12)) {
            return 1;
        }
        return -1;
    }

    private static int canConvert(TypeInfo source, TypeInfo target) {
        int temp = 0;
        if (source.getType() == target.getType() && source.getTypeDeclaration() == target.getTypeDeclaration()) {
            return 0;
        }
        if (!source.getPtrOperator().equals(target.getPtrOperator())) {
            return -1;
        }
        if (!source.getPtrOperator().equals("*")) {
            if ((source.isType(7, 10) || source.isType(11, 12) || source.isType(5)) && (target.isType(7, 10) || target.isType(11, 12))) {
                return 2;
            }
        } else {
            Declaration sourceDecl = source.getTypeDeclaration();
            Declaration targetDecl = target.getTypeDeclaration();
            if (source.isType(0) && target.isType(13)) {
                return Integer.MAX_VALUE;
            }
            if (source.isType(0) && sourceDecl.isType(2) && target.isType(0) && targetDecl.isType(2)) {
                temp = ParserSymbolTable.hasBaseClass(sourceDecl, targetDecl);
                return temp > -1 ? 1 + temp : -1;
            }
            if (source.isType(0) && sourceDecl._containingScope.isType(2) || target.isType(0) && targetDecl._containingScope.isType(2)) {
                temp = ParserSymbolTable.hasBaseClass(targetDecl._containingScope, sourceDecl._containingScope);
                return temp > -1 ? 1 + temp : -1;
            }
        }
        return -1;
    }

    private static boolean canDoQualificationConversion(TypeInfo source, TypeInfo target) {
        return source.getCVQualifier() == source.getCVQualifier() || source.getCVQualifier() - source.getCVQualifier() > 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LookupData {
        public String name;
        public Map usingDirectives;
        public Set visited = new HashSet();
        public HashSet inheritanceChain;
        public LinkedList parameters;
        public HashSet associated;
        public Declaration stopAt;
        public int type = -1;
        public int upperType = 0;
        public boolean qualified = false;
        public boolean ignoreUsingDirectives = false;

        public LookupData(String n, int t) {
            this.name = n;
            this.type = t;
        }
    }
}

