/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import org.eclipse.cdt.internal.core.parser.Declaration;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;

public class TypeInfo {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    public static final int t_type = 0;
    public static final int t_namespace = 1;
    public static final int t_class = 2;
    public static final int t_struct = 3;
    public static final int t_union = 4;
    public static final int t_enumeration = 5;
    public static final int t_function = 6;
    public static final int t_bool = 7;
    public static final int t_char = 8;
    public static final int t_wchar_t = 9;
    public static final int t_int = 10;
    public static final int t_float = 11;
    public static final int t_double = 12;
    public static final int t_void = 13;
    public static final int t_enumerator = 14;
    public static final int cvConst = 1;
    public static final int cvVolatile = 2;
    public static final int cvConstVolatile = 4;
    private int _typeInfo = 0;
    private Declaration _typeDeclaration;
    private int _cvQualifier = 0;
    private boolean _hasDefaultValue = false;
    private String _ptrOperator;

    public TypeInfo() {
    }

    public TypeInfo(int type, Declaration decl) {
        this._typeInfo = type;
        this._typeDeclaration = decl;
    }

    public TypeInfo(int type, Declaration decl, int cvQualifier, String ptrOp, boolean hasDefault) {
        this._typeInfo = type;
        this._typeDeclaration = decl;
        this._cvQualifier = cvQualifier;
        this._ptrOperator = ptrOp;
        this._hasDefaultValue = hasDefault;
    }

    public void setBit(boolean b, int mask) {
        this._typeInfo = b ? (this._typeInfo |= mask) : (this._typeInfo &= ~mask);
    }

    public boolean checkBit(int mask) {
        return (this._typeInfo & mask) != 0;
    }

    public void setType(int t) throws ParserSymbolTableException {
        if (t > 31) {
            throw new ParserSymbolTableException(1);
        }
        this._typeInfo = this._typeInfo & 0xFFFFFFE0 | t;
    }

    public int getType() {
        return this._typeInfo & 0x1F;
    }

    public boolean isType(int type) {
        return this.isType(type, 0);
    }

    public boolean isType(int type, int upperType) {
        if (type == -1) {
            return true;
        }
        if (upperType == 0) {
            return this.getType() == type;
        }
        return this.getType() >= type && this.getType() <= upperType;
    }

    public Declaration getTypeDeclaration() {
        return this._typeDeclaration;
    }

    public void setTypeDeclaration(Declaration type) {
        this._typeDeclaration = type;
    }

    public int getCVQualifier() {
        return this._cvQualifier;
    }

    public void setCVQualifier(int cv) {
        this._cvQualifier = cv;
    }

    public String getPtrOperator() {
        return this._ptrOperator;
    }

    public void setPtrOperator(String ptr) {
        this._ptrOperator = ptr;
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean def) {
        this._hasDefaultValue = def;
    }

    public boolean canHold(TypeInfo type) {
        return this.getType() >= type.getType();
    }
}

