/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Argument;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIPType;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class VariableManager
extends SessionObject
implements ICDIVariableManager {
    List variableList;
    boolean autoupdate = true;
    MIVarChange[] noChanges = new MIVarChange[0];

    public VariableManager(Session session) {
        super(session);
        this.variableList = Collections.synchronizedList(new ArrayList());
    }

    public Variable getVariable(String varName) {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                return vars[i];
            }
            Variable v = vars[i].getChild(varName);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableObject v) throws CDIException {
        ICDIStackFrame stack = v.getStackFrame();
        String name = v.getName();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(name)) {
                ICDIStackFrame frame = vars[i].getStackFrame();
                if (stack == null && frame == null) {
                    return vars[i];
                }
                if (frame != null && stack != null && frame.equals(stack) && vars[i].getVariableObject().getPosition() == position && vars[i].getVariableObject().getStackDepth() == depth) {
                    return vars[i];
                }
            }
            ++i;
        }
        return null;
    }

    Variable[] getVariables() {
        return this.variableList.toArray(new Variable[0]);
    }

    void removeMIVar(MIVar miVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            mi.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void removeVariable(String varName) throws CDIException {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                this.variableList.remove(vars[i]);
                this.removeMIVar(vars[i].getMIVar());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIArgument createArgument(ICDIArgumentObject a) throws CDIException {
        ArgumentObject argObj = null;
        if (a instanceof ArgumentObject) {
            argObj = (ArgumentObject)a;
        } else if (a instanceof Argument) {
            argObj = ((Argument)a).getArgumentObject();
        }
        if (argObj == null) throw new CDIException("Wrong variable type");
        Variable variable = this.findVariable(argObj);
        Argument argument = null;
        if (variable != null && variable instanceof Argument) {
            argument = (Argument)variable;
        }
        if (argument != null) return argument;
        String name = argObj.getName();
        ICDIStackFrame stack = argObj.getStackFrame();
        Session session = (Session)this.getSession();
        ICDIThread currentThread = null;
        ICDIStackFrame currentFrame = null;
        if (stack != null) {
            ICDITarget currentTarget = session.getCurrentTarget();
            currentThread = currentTarget.getCurrentThread();
            currentFrame = currentThread.getCurrentStackFrame();
            stack.getThread().setCurrentStackFrame(stack, false);
        }
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                argument = new Argument(argObj, info.getMIVar());
                this.variableList.add(argument);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var15_15 = null;
            if (currentThread == null) return argument;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (currentThread == null) throw throwable;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return argument;
    }

    public ICDIArgumentObject getArgumentObject(ICDIStackFrame stack, String name) throws CDIException {
        ICDIArgumentObject[] argsObjects = this.getArgumentObjects(stack);
        int i = 0;
        while (i < argsObjects.length) {
            if (argsObjects[i].getName().equals(name)) {
                return argsObjects[i];
            }
            ++i;
        }
        return null;
    }

    public ICDIArgumentObject[] getArgumentObjects(ICDIStackFrame frame) throws CDIException {
        ArrayList<ArgumentObject> argObjects = new ArrayList<ArgumentObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame, false);
        try {
            block7: {
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    int depth = frame.getThread().getStackFrameCount();
                    int level = frame.getLevel();
                    int miLevel = depth - level;
                    MIStackListArguments listArgs = factory.createMIStackListArguments(false, miLevel, miLevel);
                    MIArg[] args = null;
                    mi.postCommand(listArgs);
                    MIStackListArgumentsInfo info = listArgs.getMIStackListArgumentsInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    if (miFrames != null && miFrames.length == 1) {
                        args = miFrames[0].getArgs();
                    }
                    if (args == null) break block7;
                    ICDITarget tgt = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        ArgumentObject arg = new ArgumentObject(tgt, args[i].getName(), frame, args.length - i, level);
                        argObjects.add(arg);
                        ++i;
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            currentThread.setCurrentStackFrame(currentFrame);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame);
        return argObjects.toArray(new ICDIArgumentObject[0]);
    }

    public ICDIVariableObject getVariableObject(ICDIStackFrame stack, String name) throws CDIException {
        ICDIVariableObject[] varObjects = this.getVariableObjects(stack);
        int i = 0;
        while (i < varObjects.length) {
            if (varObjects[i].getName().equals(name)) {
                return varObjects[i];
            }
            ++i;
        }
        return null;
    }

    public ICDIVariableObject getVariableObject(String filename, String function, String name) throws CDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        ICDITarget target = this.getSession().getCurrentTarget();
        return new VariableObject(target, buffer.toString(), null, 0, 0);
    }

    public ICDIVariableObject getVariableObjectAsArray(ICDIVariableObject object, String type, int start, int length) throws CDIException {
        VariableObject obj = null;
        if (object instanceof VariableObject) {
            obj = (VariableObject)object;
        } else if (object instanceof Variable) {
            obj = ((Variable)object).getVariableObject();
        }
        if (obj != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*(");
            buffer.append('(');
            if (type != null && type.length() > 0) {
                try {
                    MISession mi = ((Session)this.getSession()).getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIPType ptype = factory.createMIPType(type);
                    mi.postCommand(ptype);
                    MIPTypeInfo info = ptype.getMIPtypeInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
                buffer.append('(').append(type).append(')');
            }
            buffer.append(obj.getName());
            buffer.append(')');
            if (start != 0) {
                buffer.append('+').append(start);
            }
            buffer.append(')');
            buffer.append('@').append(length - start);
            return new VariableObject(obj, buffer.toString());
        }
        throw new CDIException("Unknown variable object");
    }

    public ICDIVariableObject getVariableObjectAsType(ICDIVariableObject object, String type) throws CDIException {
        VariableObject obj = null;
        if (object instanceof VariableObject) {
            obj = (VariableObject)object;
        } else if (object instanceof Variable) {
            obj = ((Variable)object).getVariableObject();
        }
        if (obj != null) {
            StringBuffer buffer = new StringBuffer();
            if (type != null && type.length() > 0) {
                try {
                    MISession mi = ((Session)this.getSession()).getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIPType ptype = factory.createMIPType(type);
                    mi.postCommand(ptype);
                    MIPTypeInfo info = ptype.getMIPtypeInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
                buffer.append('(').append(type).append(')');
            }
            buffer.append('(');
            buffer.append(obj.getName());
            buffer.append(')');
            return new VariableObject(obj, buffer.toString());
        }
        throw new CDIException("Unknown variable object");
    }

    public ICDIVariableObject[] getLocalVariableObjects(ICDIStackFrame frame) throws CDIException {
        ArrayList<VariableObject> varObjects = new ArrayList<VariableObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame, false);
        try {
            block6: {
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    int level = frame.getLevel();
                    MIArg[] args = null;
                    MIStackListLocals locals = factory.createMIStackListLocals(false);
                    mi.postCommand(locals);
                    MIStackListLocalsInfo info = locals.getMIStackListLocalsInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    args = info.getLocals();
                    if (args == null) break block6;
                    ICDITarget tgt = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        VariableObject varObj = new VariableObject(tgt, args[i].getName(), frame, args.length - i, level);
                        varObjects.add(varObj);
                        ++i;
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return varObjects.toArray(new ICDIVariableObject[0]);
    }

    public ICDIVariableObject[] getVariableObjects(ICDIStackFrame frame) throws CDIException {
        ICDIVariableObject[] locals = this.getLocalVariableObjects(frame);
        ICDIArgumentObject[] args = this.getArgumentObjects(frame);
        ICDIVariableObject[] vars = new ICDIVariableObject[locals.length + args.length];
        System.arraycopy(locals, 0, vars, 0, locals.length);
        System.arraycopy(args, 0, vars, locals.length, args.length);
        return vars;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIVariable createVariable(ICDIVariableObject v) throws CDIException {
        VariableObject varObj = null;
        if (v instanceof VariableObject) {
            varObj = (VariableObject)v;
        }
        if (v instanceof Variable) {
            varObj = ((Variable)v).getVariableObject();
        }
        if (varObj == null) throw new CDIException("Wrong variable type");
        Variable variable = this.findVariable(varObj);
        if (variable != null) return variable;
        String name = varObj.getName();
        Session session = (Session)this.getSession();
        ICDIStackFrame stack = varObj.getStackFrame();
        ICDIThread currentThread = null;
        ICDIStackFrame currentFrame = null;
        if (stack != null) {
            ICDITarget currentTarget = session.getCurrentTarget();
            currentThread = currentTarget.getCurrentThread();
            currentFrame = currentThread.getCurrentStackFrame();
            stack.getThread().setCurrentStackFrame(stack, false);
        }
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                variable = new Variable(varObj, info.getMIVar());
                this.variableList.add(variable);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var14_14 = null;
            if (currentThread == null) return variable;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (currentThread == null) throw throwable;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return variable;
    }

    public void destroyVariable(ICDIVariable var) throws CDIException {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            MIVarDeletedEvent del = new MIVarDeletedEvent(variable.getMIVar().getVarName());
            Session session = (Session)this.getSession();
            MISession mi = session.getMISession();
            mi.fireEvent(del);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public void update() throws CDIException {
        ICDIThread currentThread;
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>();
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Variable[] vars = this.getVariables();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIStackFrame[] frames = null;
        ICDIStackFrame currentStack = null;
        if (currentTarget != null && (currentThread = currentTarget.getCurrentThread()) != null) {
            frames = currentThread.getStackFrames();
            currentStack = currentThread.getCurrentStackFrame();
        }
        int i = 0;
        while (i < vars.length) {
            Variable variable = vars[i];
            if (this.isVariableNeedsUpdate(variable, currentStack, frames)) {
                String varName = variable.getMIVar().getVarName();
                MIVarChange[] changes = this.noChanges;
                MIVarUpdate update = factory.createMIVarUpdate(varName);
                try {
                    mi.postCommand(update);
                    MIVarUpdateInfo info = update.getMIVarUpdateInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    changes = info.getMIVarChanges();
                }
                catch (MIException e) {
                    eventList.add(new MIVarDeletedEvent(varName));
                }
                int j = 0;
                while (j < changes.length) {
                    String n = changes[j].getVarName();
                    if (changes[j].isInScope()) {
                        eventList.add(new MIVarChangedEvent(n));
                    } else {
                        eventList.add(new MIVarDeletedEvent(n));
                    }
                    ++j;
                }
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    boolean isVariableNeedsUpdate(Variable variable, ICDIStackFrame current, ICDIStackFrame[] frames) throws CDIException {
        ICDIStackFrame varStack = variable.getStackFrame();
        boolean inScope = false;
        if (current == null || frames == null) {
            return false;
        }
        if (varStack == null) {
            return true;
        }
        if (varStack.equals(current)) {
            return true;
        }
        int i = 0;
        while (i < frames.length) {
            if (varStack.equals(frames[i])) {
                inScope = true;
            }
            ++i;
        }
        return !inScope;
    }
}

