/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.command.MIVarSetFormat;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public class Variable
extends CObject
implements ICDIVariable {
    MIVar miVar;
    Value value;
    VariableObject varObj;
    ICDIVariable[] children = new ICDIVariable[0];

    public Variable(VariableObject obj, MIVar v) {
        super(obj.getTarget());
        this.miVar = v;
        this.varObj = obj;
    }

    public MIVar getMIVar() {
        return this.miVar;
    }

    public VariableObject getVariableObject() {
        return this.varObj;
    }

    public Variable getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            Variable variable = (Variable)this.children[i];
            if (name.equals(variable.getMIVar().getVarName())) {
                return variable;
            }
            Variable grandChild = variable.getChild(name);
            if (grandChild != null) {
                return grandChild;
            }
            ++i;
        }
        return null;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIVar[] vars = info.getMIVars();
            this.children = new Variable[vars.length];
            int i = 0;
            while (i < vars.length) {
                VariableObject varObj = new VariableObject(this.getTarget(), vars[i].getExp(), this.getStackFrame(), this.getVariableObject().getPosition(), this.getVariableObject().getStackDepth());
                this.children[i] = new Variable(varObj, vars[i]);
                ++i;
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return this.children;
    }

    public int getChildrenNumber() throws CDIException {
        return this.miVar.getNumChild();
    }

    public String getName() {
        return this.varObj.getName();
    }

    public String getTypeName() throws CDIException {
        return this.miVar.getType();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            this.value = new Value(this);
        }
        return this.value;
    }

    public void setValue(ICDIValue value) throws CDIException {
        this.setValue(value.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.miVar.getVarName(), expression);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        ICDIVariableManager mgr = session.getVariableManager();
        MIVarChangedEvent change = new MIVarChangedEvent(var.getToken(), this.miVar.getVarName());
        mi.fireEvent(change);
        if (mgr.isAutoUpdate()) {
            mgr.update();
        }
    }

    public boolean isEditable() throws CDIException {
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarShowAttributes var = factory.createMIVarShowAttributes(this.miVar.getVarName());
        try {
            mi.postCommand(var);
            MIVarShowAttributesInfo info = var.getMIVarShowAttributesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.isEditable();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void setFormat(int format) throws CDIException {
        int fmt = Format.toMIFormat(format);
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarSetFormat var = factory.createMIVarSetFormat(this.miVar.getVarName(), fmt);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean equals(ICDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.miVar.getVarName().equals(variable.getMIVar().getVarName());
        }
        return super.equals(var);
    }

    public ICDIStackFrame getStackFrame() throws CDIException {
        return this.varObj.getStackFrame();
    }
}

