/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIFrame {
    int level;
    long addr;
    String func = "";
    String file = "";
    int line;
    MIArg[] args = new MIArg[0];

    public MIFrame(MITuple tuple) {
        this.parse(tuple);
    }

    public MIArg[] getArgs() {
        return this.args;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunction() {
        return this.func;
    }

    public int getLine() {
        return this.line;
    }

    public long getAddress() {
        return this.addr;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("level=\"" + this.level + "\"");
        buffer.append(",addr=\"" + Long.toHexString(this.addr) + "\"");
        buffer.append(",func=\"" + this.func + "\"");
        buffer.append(",file=\"" + this.file + "\"");
        buffer.append(",line=\"").append(this.line).append('\"');
        buffer.append(",args=[");
        int i = 0;
        while (i < this.args.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append("{name=\"" + this.args[i].getName() + "\"");
            buffer.append(",value=\"" + this.args[i].getValue() + "\"}");
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("level")) {
                try {
                    this.level = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("addr")) {
                try {
                    this.addr = Long.decode(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("func")) {
                this.func = str;
            } else if (var.equals("file")) {
                this.file = str;
            } else if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("args") && value instanceof MIList) {
                this.args = MIArg.getMIArgs((MIList)value);
            }
            ++i;
        }
    }
}

