/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IGlobalVariable;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AddGlobalsActionDelegate
implements IViewActionDelegate,
ISelectionListener,
IPartListener {
    private Global[] fGlobals;
    private IViewPart fView = null;
    private IAction fAction;
    private IStructuredSelection fSelection;
    private IStatus fStatus = null;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IExecFileInfo;

    public void init(IViewPart view) {
        this.fView = view;
        view.getSite().getPage().addPartListener((IPartListener)this);
        view.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            if (selection instanceof IStructuredSelection) {
                this.setSelection((IStructuredSelection)selection);
            } else {
                this.setSelection(null);
            }
            this.update(this.getAction());
        }
    }

    public void run(IAction action) {
        final IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() != 1) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    AddGlobalsActionDelegate.this.doAction(selection.getFirstElement());
                    AddGlobalsActionDelegate.this.setStatus(null);
                }
                catch (DebugException e) {
                    AddGlobalsActionDelegate.this.setStatus(e.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog(this.getErrorDialogMessage(), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (this.getView() != null) {
            this.update(action);
        }
    }

    protected void update(IAction action) {
        if (action != null) {
            action.setEnabled(this.getEnableStateForSelection(this.getSelection()));
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart viewPart) {
        this.fView = viewPart;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void dispose() {
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof IDebugElement && ((IDebugElement)element).getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$IExecFileInfo == null ? (class$org$eclipse$cdt$debug$core$model$IExecFileInfo = AddGlobalsActionDelegate.class$("org.eclipse.cdt.debug.core.model.IExecFileInfo")) : class$org$eclipse$cdt$debug$core$model$IExecFileInfo) != null;
    }

    private ListSelectionDialog createDialog() {
        return new ListSelectionDialog(this.getView().getSite().getShell(), (Object)this.fGlobals, new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return AddGlobalsActionDelegate.this.getGlobals();
            }
        }, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Global) {
                    int index;
                    String path = "";
                    if (((Global)element).getPath() != null && (index = (path = ((Global)element).getPath().toString()).lastIndexOf(47)) != -1) {
                        path = path.substring(index + 1);
                    }
                    return (path.length() > 0 ? '\'' + path + "'::" : "") + ((Global)element).getName();
                }
                return null;
            }
        }, "Select Variables:");
    }

    protected Global[] getGlobals() {
        return this.fGlobals;
    }

    protected void doAction(Object element) throws DebugException {
        IExecFileInfo info;
        if (this.getView() == null) {
            return;
        }
        if (element != null && element instanceof IDebugElement && (info = (IExecFileInfo)((IDebugElement)element).getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$IExecFileInfo == null ? (class$org$eclipse$cdt$debug$core$model$IExecFileInfo = AddGlobalsActionDelegate.class$("org.eclipse.cdt.debug.core.model.IExecFileInfo")) : class$org$eclipse$cdt$debug$core$model$IExecFileInfo)) != null) {
            IGlobalVariable[] globalVars = info.getGlobals();
            this.fGlobals = new Global[globalVars.length];
            int i = 0;
            while (i < globalVars.length) {
                this.fGlobals[i] = new Global(globalVars[i].getName(), globalVars[i].getPath());
                ++i;
            }
            ListSelectionDialog dlg = this.createDialog();
            if (dlg.open() == 0) {
                Object[] selections = dlg.getResult();
                int i2 = 0;
                while (i2 < selections.length) {
                    this.createExpression(((IDebugElement)element).getDebugTarget(), ((Global)selections[i2]).toString());
                    ++i2;
                }
            }
        }
    }

    protected String getStatusMessage() {
        return "Exceptions occurred attempting to add global variables.";
    }

    protected String getErrorDialogMessage() {
        return "Add global variables failed.";
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected IStatus getStatus() {
        return this.fStatus;
    }

    private void createExpression(IDebugTarget target, String text) throws DebugException {
        IExpression expression = CDebugModel.createExpression((IDebugTarget)target, (String)text);
        DebugPlugin.getDefault().getExpressionManager().addExpression(expression);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Global {
        private String fName;
        private IPath fPath;

        public Global(String name, IPath path) {
            this.fName = name;
            this.fPath = path;
        }

        public String getName() {
            return this.fName;
        }

        public IPath getPath() {
            return this.fPath;
        }

        public String toString() {
            int index;
            String path = "";
            if (this.getPath() != null && (index = (path = this.getPath().toString()).lastIndexOf(47)) != -1) {
                path = path.substring(index + 1);
            }
            return (path.length() > 0 ? '\'' + path + "'::" : "") + this.getName();
        }
    }
}

