/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class CastToTypeActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICastToType fCastToType = null;
    private IStatus fStatus = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getCastToType() == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    CastToTypeActionDelegate.this.doAction(CastToTypeActionDelegate.this.getCastToType());
                    CastToTypeActionDelegate.this.setStatus(null);
                }
                catch (DebugException e) {
                    CastToTypeActionDelegate.this.setStatus(e.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog("Unable to cast to type.", this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICastToType) {
            boolean enabled = ((ICastToType)element).supportsCasting();
            action.setEnabled(enabled);
            if (enabled) {
                this.setCastToType((ICastToType)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setCastToType(null);
    }

    protected ICastToType getCastToType() {
        return this.fCastToType;
    }

    protected void setCastToType(ICastToType castToType) {
        this.fCastToType = castToType;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void doAction(ICastToType castToType) throws DebugException {
        String currentType = castToType.getCurrentType().trim();
        CastToTypeDialog dialog = new CastToTypeDialog(CDebugUIPlugin.getActiveWorkbenchShell(), currentType);
        if (dialog.open() == 0) {
            String newType = dialog.getValue().trim();
            castToType.cast(newType);
        }
    }

    protected class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell parentShell, String initialValue) {
            super(parentShell, "Cast To Type", "Enter type:", initialValue, (IInputValidator)new CastToTypeInputValidator());
        }
    }

    protected static class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "The 'Type' field must not be empty.";
            }
            return null;
        }
    }
}

