/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IJumpToAddress;
import org.eclipse.cdt.debug.core.model.IJumpToLine;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JumpToLineActionDelegate
extends AbstractEditorActionDelegate {
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IJumpToLine;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IJumpToAddress;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part != null && part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && (target1 instanceof IJumpToLine || target1 instanceof IJumpToAddress)) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    public void run(IAction action) {
        if (this.getTargetPart() != null && this.getTargetPart() instanceof ITextEditor) {
            IEditorInput input = ((ITextEditor)this.getTargetPart()).getEditorInput();
            if (input != null && input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (file != null) {
                    ITextSelection selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
                    int lineNumber = selection.getStartLine() + 1;
                    this.jumpToLine((IResource)file, lineNumber);
                }
            } else if (input != null && input instanceof IStorageEditorInput) {
                try {
                    ITextSelection selection;
                    int lineNumber;
                    IDisassemblyStorage disassemblyStorage;
                    long address;
                    IStorage storage = ((IStorageEditorInput)input).getStorage();
                    if (storage != null && storage.getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage = JumpToLineActionDelegate.class$("org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage")) : class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage) != null && (address = (disassemblyStorage = (IDisassemblyStorage)storage.getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage = JumpToLineActionDelegate.class$("org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage")) : class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage)).getAddress(lineNumber = (selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection()).getStartLine())) > 0L) {
                        this.jumpToAddress(address);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && (target instanceof IJumpToLine || target instanceof IJumpToAddress)) {
            this.setDebugTarget(target);
        }
    }

    protected void jumpToLine(IResource resource, int lineNumber) {
        IJumpToLine target = (IJumpToLine)this.getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$IJumpToLine == null ? (class$org$eclipse$cdt$debug$core$model$IJumpToLine = JumpToLineActionDelegate.class$("org.eclipse.cdt.debug.core.model.IJumpToLine")) : class$org$eclipse$cdt$debug$core$model$IJumpToLine);
        if (target != null) {
            if (!target.canJumpToLine(resource, lineNumber)) {
                this.getTargetPart().getSite().getShell().getDisplay().beep();
                return;
            }
            try {
                target.jumpToLine(resource, lineNumber);
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), e);
            }
        }
    }

    protected void jumpToAddress(long address) {
        IJumpToAddress target = (IJumpToAddress)this.getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$IJumpToAddress == null ? (class$org$eclipse$cdt$debug$core$model$IJumpToAddress = JumpToLineActionDelegate.class$("org.eclipse.cdt.debug.core.model.IJumpToAddress")) : class$org$eclipse$cdt$debug$core$model$IJumpToAddress);
        if (target != null) {
            if (!target.canJumpToAddress(address)) {
                this.getTargetPart().getSite().getShell().getDisplay().beep();
                return;
            }
            try {
                target.jumpToAddress(address);
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

