/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryControlArea;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MemoryViewer
extends ContentViewer {
    private static final int NUMBER_OF_TABS = 4;
    protected MemoryView fView = null;
    protected Composite fParent = null;
    protected CTabFolder fTabFolder = null;
    private Composite fControl = null;
    private MemoryControlArea[] fMemoryControlAreas = new MemoryControlArea[4];

    public MemoryViewer(Composite parent, MemoryView view) {
        this.fParent = parent;
        this.fView = view;
    }

    public Control getControl() {
        if (this.fControl == null) {
            this.fControl = new Composite(this.fParent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fControl.setLayout((Layout)layout);
            this.fControl.setLayoutData((Object)new GridData(1808));
            this.fTabFolder = new CTabFolder(this.fControl, 128);
            this.fTabFolder.setLayoutData((Object)new GridData(1808));
            int i = 0;
            while (i < 4) {
                CTabItem tabItem = new CTabItem(this.fTabFolder, 0);
                tabItem.setText("Memory " + (i + 1));
                this.fMemoryControlAreas[i] = new MemoryControlArea((Composite)this.fTabFolder, 0, i, this.fView);
                tabItem.setControl((Control)this.fMemoryControlAreas[i]);
                ++i;
            }
            this.fTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MemoryViewer.this.fView.updateObjects();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    MemoryViewer.this.fView.updateObjects();
                }
            });
            this.fTabFolder.setSelection(0);
        }
        return this.fControl;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        if (this.fTabFolder != null) {
            CTabItem[] tabItems = this.fTabFolder.getItems();
            int i = 0;
            while (i < tabItems.length) {
                if (tabItems[i].getControl() instanceof MemoryControlArea) {
                    ((MemoryControlArea)tabItems[i].getControl()).refresh();
                }
                ++i;
            }
        }
    }

    public void refresh(Object element) {
        MemoryControlArea mca;
        if (element instanceof IFormattedMemoryBlock && (mca = this.getMemoryControlArea((IFormattedMemoryBlock)element)) != null) {
            mca.refresh();
        }
    }

    public void remove(Object element) {
        MemoryControlArea mca;
        if (element instanceof IFormattedMemoryBlock && (mca = this.getMemoryControlArea((IFormattedMemoryBlock)element)) != null) {
            mca.clear();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fTabFolder != null) {
            CTabItem[] tabItems = this.fTabFolder.getItems();
            int i = 0;
            while (i < tabItems.length) {
                if (tabItems[i].getControl() instanceof MemoryControlArea) {
                    ((MemoryControlArea)tabItems[i].getControl()).propertyChange(event);
                }
                ++i;
            }
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        int i = 0;
        while (i < this.fMemoryControlAreas.length) {
            this.fMemoryControlAreas[i].setInput((ICMemoryManager)input);
            ++i;
        }
    }

    protected CTabFolder getTabFolder() {
        return this.fTabFolder;
    }

    private MemoryControlArea getMemoryControlArea(int index) {
        CTabItem item = this.fTabFolder.getItem(index);
        return item != null ? (MemoryControlArea)item.getControl() : null;
    }

    private MemoryControlArea getMemoryControlArea(IFormattedMemoryBlock block) {
        CTabItem[] tabItems = this.fTabFolder.getItems();
        int i = 0;
        while (i < tabItems.length) {
            if (tabItems[i].getControl() instanceof MemoryControlArea && block != null && block.equals(((MemoryControlArea)tabItems[i].getControl()).getMemoryBlock())) {
                return (MemoryControlArea)tabItems[i].getControl();
            }
            ++i;
        }
        return null;
    }

    public boolean canChangeFormat(int format) {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return block != null && block.canChangeFormat(format);
    }

    public boolean canUpdate() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock() != null;
    }

    public boolean canSave() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock() != null;
    }

    public boolean isFrozen() {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return block != null ? block.isFrozen() : true;
    }

    public void setFrozen(boolean frozen) {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (block != null) {
            block.setFrozen(frozen);
        }
    }

    public void clear() {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).clear();
    }

    public void refreshMemoryBlock() {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refreshMemoryBlock();
    }

    public boolean showAscii() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().displayASCII();
    }

    public void setShowAscii(boolean show) {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().setDisplayAscii(show);
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
    }

    public boolean canShowAscii() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().canDisplayAscii();
    }

    public int getCurrentFormat() {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return block != null ? block.getFormat() : 0;
    }

    public void setFormat(int format) throws DebugException {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (block != null) {
            block.reformat(format, block.getWordSize(), block.getNumberOfRows(), block.getNumberOfColumns());
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }

    public int getCurrentWordSize() {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return block != null ? block.getWordSize() : 0;
    }

    public void setWordSize(int size) throws DebugException {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (block != null) {
            block.reformat(block.getFormat(), size, block.getNumberOfRows(), block.getNumberOfColumns());
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }

    public int getCurrentNumberOfColumns() {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return block != null ? block.getNumberOfColumns() : 0;
    }

    public void setNumberOfColumns(int numberOfColumns) throws DebugException {
        IFormattedMemoryBlock block = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (block != null) {
            block.reformat(block.getFormat(), block.getWordSize(), block.getNumberOfRows(), numberOfColumns);
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }
}

