/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CUISourceLocator
implements IAdaptable {
    private IProject fProject = null;
    private CSourceManager fSourceLocator;
    protected boolean fAllowedToAsk;
    protected boolean fNewLocationAttached;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IStackFrameInfo;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode;

    public CUISourceLocator(IProject project) {
        this.fProject = project;
        this.fSourceLocator = new CSourceManager((ISourceLocator)new CSourceLocator(project));
        this.fAllowedToAsk = true;
        this.fNewLocationAttached = false;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        IStackFrameInfo frameInfo;
        Object res = this.fSourceLocator.getSourceElement(stackFrame);
        if (res == null && this.fAllowedToAsk && (frameInfo = (IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CUISourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo)) != null && frameInfo.getFile() != null && frameInfo.getFile().length() > 0) {
            res = new FileNotFoundElement(stackFrame);
        }
        return res;
    }

    private void showDebugSourcePage(final ILaunch launch, final String fileName) {
        Runnable prompter = new Runnable(){

            public void run() {
                SourceLookupDialog dialog = new SourceLookupDialog(CDebugUIPlugin.getActiveWorkbenchShell(), fileName);
                if (dialog.open() == 1000) {
                    CUISourceLocator.this.attachSourceLocation(launch, fileName);
                }
                CUISourceLocator.this.fAllowedToAsk = !dialog.isNotAskAgain();
            }
        };
        CDebugUIPlugin.getStandardDisplay().syncExec(prompter);
    }

    protected void attachSourceLocation(ILaunch launch, String fileName) {
        Path path = new Path(fileName);
        Wizard wizard = null;
        if (path.isAbsolute()) {
            path = path.removeLastSegments(1);
            wizard = new AddDirectorySourceLocationWizard((IPath)path);
        } else {
            wizard = new AddSourceLocationWizard(this.fSourceLocator.getSourceLocations());
        }
        WizardDialog dialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fSourceLocator.addSourceLocation(wizard.getSourceLocation());
            if (launch.getSourceLocator() instanceof IPersistableSourceLocator) {
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                this.saveChanges(configuration, (IPersistableSourceLocator)launch.getSourceLocator());
            }
            this.fNewLocationAttached = true;
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.fSourceLocator != null) {
            if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CUISourceLocator.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator)) {
                return this.fSourceLocator;
            }
            if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode = CUISourceLocator.class$("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode")) : class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode)) {
                return this.fSourceLocator;
            }
        }
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), (IStatus)null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SourceLookupDialog
    extends Dialog {
        public static final int ATTACH_ID = 1000;
        public static final int ATTACH = 1000;
        private String fFileName;
        private boolean fNotAskAgain;
        private Button fAskAgainCheckBox;

        public SourceLookupDialog(Shell shell, String fileName) {
            super(shell);
            this.fFileName = fileName;
            this.fNotAskAgain = false;
            this.fAskAgainCheckBox = null;
        }

        public boolean isNotAskAgain() {
            return this.fNotAskAgain;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Debugger Source Lookup");
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout());
            Composite group = new Composite(composite, 0);
            group.setLayout((Layout)new GridLayout());
            this.createMessageControls(group);
            this.createControls(group);
            return composite;
        }

        protected void createMessageControls(Composite parent) {
            Label message = new Label(parent, 16448);
            message.setText(MessageFormat.format("The source could not be shown as the file ''{0}'' was not found.", this.fFileName));
            GridData data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels((Control)message, 70);
            message.setLayoutData((Object)data);
        }

        protected void createControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            this.fAskAgainCheckBox = new Button(composite, 96);
            data = new GridData();
            data.horizontalAlignment = 4;
            this.fAskAgainCheckBox.setLayoutData((Object)data);
            data.grabExcessHorizontalSpace = true;
            this.fAskAgainCheckBox.setText("Do &not ask again");
            this.fAskAgainCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ SourceLookupDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.askAgainSelected();
                }
            });
        }

        protected void askAgainSelected() {
            this.getButton(1000).setEnabled(!this.fAskAgainCheckBox.getSelection());
        }

        protected int convertWidthInCharsToPixels(Control control, int chars) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
        }

        protected void okPressed() {
            if (this.fAskAgainCheckBox != null) {
                this.fNotAskAgain = this.fAskAgainCheckBox.getSelection();
            }
            super.okPressed();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button button = this.createButton(parent, 1000, "&Attach ...", false);
            button.setToolTipText("Attach New Source Location");
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1000) {
                this.attachPressed();
            }
        }

        protected void attachPressed() {
            this.setReturnCode(1000);
            this.close();
        }
    }
}

