/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

public class SourcePropertyPage
extends PropertyPage {
    private SourceLookupBlock fBlock = null;
    private boolean fHasActiveContents = false;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICDebugTarget;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator;

    public SourcePropertyPage() {
        this.noDefaultAndApplyButton();
        this.fBlock = new SourceLookupBlock();
    }

    protected Control createContents(Composite parent) {
        ICDebugTarget target = this.getDebugTarget();
        if (target == null || target.isTerminated() || target.isDisconnected()) {
            return this.createTerminatedContents(parent);
        }
        this.fHasActiveContents = true;
        return this.createActiveContents(parent);
    }

    protected Control createTerminatedContents(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("Terminated.");
        return label;
    }

    protected Control createActiveContents(Composite parent) {
        this.fBlock.setProject(this.getProject());
        this.fBlock.initialize(this.getSourceLocator());
        this.fBlock.createControl(parent);
        return this.fBlock.getControl();
    }

    protected ICDebugTarget getDebugTarget() {
        IAdaptable element = this.getElement();
        if (element != null) {
            return (ICDebugTarget)element.getAdapter(class$org$eclipse$cdt$debug$core$model$ICDebugTarget == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTarget = SourcePropertyPage.class$("org.eclipse.cdt.debug.core.model.ICDebugTarget")) : class$org$eclipse$cdt$debug$core$model$ICDebugTarget);
        }
        return null;
    }

    private ICSourceLocator getSourceLocator() {
        ICDebugTarget target = this.getDebugTarget();
        if (target != null && target.getLaunch().getSourceLocator() instanceof IAdaptable) {
            return (ICSourceLocator)((IAdaptable)target.getLaunch().getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = SourcePropertyPage.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator);
        }
        return null;
    }

    public boolean performOk() {
        if (this.fBlock.isDirty()) {
            try {
                this.setSourceLocations(this.fBlock.getSourceLocations());
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog(e.getMessage(), (IStatus)null);
                return false;
            }
        }
        return true;
    }

    private void setSourceLocations(ICSourceLocation[] locations) throws DebugException {
        ICSourceLocator locator;
        ICDebugTarget target = this.getDebugTarget();
        if (target != null && target.getLaunch().getSourceLocator() instanceof IAdaptable && (locator = (ICSourceLocator)((IAdaptable)target.getLaunch().getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = SourcePropertyPage.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator)) != null) {
            locator.setSourceLocations(locations);
            if (target.getLaunch().getSourceLocator() instanceof IPersistableSourceLocator) {
                ILaunchConfiguration configuration = target.getLaunch().getLaunchConfiguration();
                this.saveChanges(configuration, (IPersistableSourceLocator)target.getLaunch().getSourceLocator());
            }
        }
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), (IStatus)null);
        }
    }

    private IProject getProject() {
        IProject project = null;
        ICDebugTarget target = this.getDebugTarget();
        if (target != null) {
            ILaunchConfiguration configuration = target.getLaunch().getLaunchConfiguration();
            try {
                String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                if (projectName != null && projectName.length() > 0) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

