/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.util.Map;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCDebuggerTab
extends CLaunchConfigurationTab {
    protected ILaunchConfiguration fLaunchConfiguration;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ICDebugConfiguration fCurrentDebugConfig;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    private boolean fInitDefaults;

    protected void setDebugConfig(ICDebugConfiguration config) {
        this.fCurrentDebugConfig = config;
    }

    protected ICDebugConfiguration getDebugConfig() {
        return this.fCurrentDebugConfig;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void handleDebuggerChanged() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (wc != null) {
                wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", (Map)null);
            }
        } else {
            if (wc == null) {
                try {
                    if (this.getLaunchConfiguration().isWorkingCopy()) {
                        this.setLaunchConfigurationWorkingCopy((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration());
                    } else {
                        this.setLaunchConfigurationWorkingCopy(this.getLaunchConfiguration().getWorkingCopy());
                    }
                    wc = this.getLaunchConfigurationWorkingCopy();
                }
                catch (CoreException e) {
                    return;
                }
            }
            if (this.initDefaults()) {
                this.getDynamicTab().setDefaults(wc);
            }
            this.setInitializeDefault(false);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void loadDynamicDebugArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        ICDebugConfiguration debugConfig = this.getConfigForCurrentDebugger();
        if (debugConfig == null) {
            this.setDynamicTab(null);
        } else {
            this.setDynamicTab(CDebugUIPlugin.getDefault().getDebuggerPage(debugConfig.getID()));
            ICDebugConfiguration oldConfig = this.getDebugConfig();
            if (oldConfig != null && oldConfig != debugConfig) {
                this.setInitializeDefault(true);
            }
        }
        this.setDebugConfig(debugConfig);
        if (this.getDynamicTab() == null) {
            return;
        }
        this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.getDynamicTab().createControl(this.getDynamicTabHolder());
        this.getDynamicTab().getControl().setVisible(true);
        this.getDynamicTabHolder().layout(true);
    }

    protected abstract ICDebugConfiguration getConfigForCurrentDebugger();

    public abstract void createControl(Composite var1);

    public abstract String getName();

    public void initializeFrom(ILaunchConfiguration config) {
        this.setLaunchConfiguration(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(config);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getDebugConfig() != null) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebugConfig().getID());
            ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", (Map)null);
            } else {
                dynamicTab.performApply(config);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
            this.setInitializeDefault(false);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebugConfig() == null) {
            this.setErrorMessage("No debugger available");
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    protected void setInitializeDefault(boolean init) {
        this.fInitDefaults = init;
    }

    protected boolean initDefaults() {
        return this.fInitDefaults;
    }
}

