/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public BaseCElementContentProvider() {
    }

    public BaseCElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public void setProvideWorkingCopy(boolean b) {
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ICElement) {
            ICElement celement = (ICElement)element;
            if (celement instanceof ICModel) {
                return this.getCProjects((ICModel)celement);
            }
            if (celement instanceof ICProject) {
                return this.getCProjectResources((ICProject)celement);
            }
            if (celement instanceof ICContainer) {
                return this.getCResources((ICContainer)celement);
            }
            if (celement.getElementType() == 60) {
                if (this.fProvideMembers) {
                    return ((IParent)element).getChildren();
                }
            } else if (celement instanceof IParent) {
                return ((IParent)celement).getChildren();
            }
        }
        return this.getResources(element);
    }

    public boolean hasChildren(Object element) {
        if (this.fProvideMembers) {
            if (element instanceof IBinary || element instanceof ITranslationUnit || element instanceof IArchive) {
                return true;
            }
        } else if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive) {
            return false;
        }
        if (element instanceof ICProject) {
            ICProject cp = (ICProject)element;
            return cp.getProject().isOpen();
        }
        if (element instanceof ICContainer) {
            return true;
        }
        if (element instanceof IParent) {
            return ((IParent)element).hasChildren();
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (element instanceof ICElement) {
            return ((ICElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    protected Object[] getCProjects(ICModel cModel) {
        return cModel.getCProjects();
    }

    protected Object[] getCProjectResources(ICProject cproject) {
        IBinaryContainer bins;
        Object[] objects = this.getCResources((ICContainer)cproject);
        IArchiveContainer archives = cproject.getArchiveContainer();
        if (archives.hasChildren()) {
            objects = BaseCElementContentProvider.concatenate(objects, new Object[]{archives});
        }
        if ((bins = cproject.getBinaryContainer()).hasChildren()) {
            objects = BaseCElementContentProvider.concatenate(objects, new Object[]{bins});
        }
        return objects;
    }

    protected Object[] getCResources(ICContainer container) {
        Object[] objects = null;
        Object[] children = container.getChildren();
        try {
            objects = container.getNonCResources();
        }
        catch (CModelException e) {
            // empty catch block
        }
        if (objects == null) {
            return children;
        }
        return BaseCElementContentProvider.concatenate(children, objects);
    }

    private Object[] getResources(Object resource) {
        try {
            if (resource instanceof IContainer) {
                IResource[] members = ((IContainer)resource).members();
                ArrayList<IResource> nonCResources = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    IResource o = members[i];
                    nonCResources.add(o);
                    ++i;
                }
                return nonCResources.toArray();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return NO_CHILDREN;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        return true;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

