/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class CCommentAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void jdocIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end >= start) {
                buf.append(d.get(start, end - start));
                if (end < c.offset) {
                    if (d.getChar(end) == '/') {
                        buf.append(" * ");
                    } else if (d.getChar(end) == '*') {
                        buf.append("* ");
                    }
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void jdocIndentForCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.jdocIndentAfterNewLine(d, c);
        } else if ("/".equals(c.text)) {
            this.jdocIndentForCommentEnd(d, c);
        }
    }
}

