/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import java.util.ArrayList;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.Templates;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContextType;
import org.eclipse.cdt.internal.corext.template.c.ICompilationUnit;
import org.eclipse.cdt.internal.ui.text.ICCompletionProposal;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.template.TemplateLabelProvider;
import org.eclipse.cdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITableLabelProvider;

public class TemplateEngine {
    private ContextType fContextType;
    private ITableLabelProvider fLabelProvider = new TemplateLabelProvider();
    private ArrayList fProposals = new ArrayList();

    public TemplateEngine(ContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public ICCompletionProposal[] getResults() {
        return this.fProposals.toArray(new ICCompletionProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (LinkedPositionManager.hasActiveManager(document)) {
            return;
        }
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        ((CompilationUnitContextType)this.fContextType).setContextParameters(document.get(), completionPosition, compilationUnit);
        CompilationUnitContext context = (CompilationUnitContext)this.fContextType.createContext();
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = Templates.getInstance().getTemplates();
        int i = 0;
        while (i != templates.length) {
            if (context.canEvaluate(templates[i])) {
                this.fProposals.add(new TemplateProposal(templates[i], context, (IRegion)region, viewer, this.fLabelProvider.getColumnImage((Object)templates[i], 0)));
            }
            ++i;
        }
    }
}

