/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSharedLibrary;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class CSharedLibraryManager
implements ICSharedLibraryManager {
    private CDebugTarget fDebugTarget = null;
    private ArrayList fSharedLibraries;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICUpdateManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICSharedLibraryManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICDebugTarget;

    public CSharedLibraryManager(CDebugTarget target) {
        this.setDebugTarget(target);
        this.fSharedLibraries = new ArrayList(5);
    }

    public synchronized void sharedLibraryLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = new CSharedLibrary(this.fDebugTarget, cdiLibrary);
        this.fSharedLibraries.add(library);
        library.fireCreationEvent();
    }

    public synchronized void sharedLibraryUnloaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            ((AbstractCollection)this.fSharedLibraries).remove(library);
            library.dispose();
            library.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            ((CDebugTarget)this.getDebugTarget()).setRetryBreakpoints(true);
            library.fireChangeEvent(256);
        }
    }

    public ICSharedLibrary[] getSharedLibraries() {
        return this.fSharedLibraries.toArray(new ICSharedLibrary[this.fSharedLibraries.size()]);
    }

    public void dispose() {
        Iterator it = ((AbstractList)this.fSharedLibraries).iterator();
        while (it.hasNext()) {
            ((ICSharedLibrary)it.next()).dispose();
        }
        this.fSharedLibraries.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICUpdateManager == null ? (class$org$eclipse$cdt$debug$core$ICUpdateManager = CSharedLibraryManager.class$("org.eclipse.cdt.debug.core.ICUpdateManager")) : class$org$eclipse$cdt$debug$core$ICUpdateManager)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICSharedLibraryManager == null ? (class$org$eclipse$cdt$debug$core$ICSharedLibraryManager = CSharedLibraryManager.class$("org.eclipse.cdt.debug.core.ICSharedLibraryManager")) : class$org$eclipse$cdt$debug$core$ICSharedLibraryManager)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager == null ? (class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager = CSharedLibraryManager.class$("org.eclipse.cdt.debug.internal.core.CSharedLibraryManager")) : class$org$eclipse$cdt$debug$internal$core$CSharedLibraryManager)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$debug$core$model$IDebugTarget == null ? (class$org$eclipse$debug$core$model$IDebugTarget = CSharedLibraryManager.class$("org.eclipse.debug.core.model.IDebugTarget")) : class$org$eclipse$debug$core$model$IDebugTarget)) {
            return this.fDebugTarget;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$ICDebugTarget == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTarget = CSharedLibraryManager.class$("org.eclipse.cdt.debug.core.model.ICDebugTarget")) : class$org$eclipse$cdt$debug$core$model$ICDebugTarget)) {
            return this.fDebugTarget;
        }
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected CSharedLibrary find(ICDISharedLibrary cdiLibrary) {
        Iterator it = ((AbstractList)this.fSharedLibraries).iterator();
        while (it.hasNext()) {
            CSharedLibrary library = (CSharedLibrary)it.next();
            if (!library.getCDISharedLibrary().equals(cdiLibrary)) continue;
            return library;
        }
        return null;
    }

    public boolean getAutoModeEnabled() {
        if (this.getCDIManager() != null) {
            return this.getCDIManager().isAutoUpdate();
        }
        return false;
    }

    public void setAutoModeEnabled(boolean enable) {
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(enable);
        }
    }

    public void update() throws DebugException {
        if (this.getCDIManager() != null) {
            try {
                this.getCDIManager().update();
            }
            catch (CDIException e) {
                ((CDebugTarget)this.getDebugTarget()).targetRequestFailed(e.toString(), null);
            }
        }
    }

    private ICDISharedLibraryManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return ((CDebugTarget)this.getDebugTarget()).getCDISession().getSharedLibraryManager();
        }
        return null;
    }

    public boolean canUpdate() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().isSuspended();
        }
        return false;
    }

    public void loadSymbols(ICSharedLibrary[] libraries) throws DebugException {
        ICDISharedLibraryManager slm = this.getCDIManager();
        if (slm != null) {
            ArrayList<ICDISharedLibrary> cdiLibs = new ArrayList<ICDISharedLibrary>(libraries.length);
            int i = 0;
            while (i < libraries.length) {
                cdiLibs.add(((CSharedLibrary)libraries[i]).getCDISharedLibrary());
                ++i;
            }
            try {
                slm.loadSymbols(cdiLibs.toArray(new ICDISharedLibrary[cdiLibs.size()]));
            }
            catch (CDIException e) {
                ((CDebugTarget)this.getDebugTarget()).targetRequestFailed(e.toString(), null);
            }
        }
    }

    public void loadSymbolsForAll() throws DebugException {
        ICDISharedLibraryManager slm = this.getCDIManager();
        if (slm != null) {
            try {
                slm.loadSymbols();
            }
            catch (CDIException e) {
                ((CDebugTarget)this.getDebugTarget()).targetRequestFailed(e.toString(), null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

