/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ICRoot;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class CContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected StructuredViewer fViewer;
    protected Object fInput;
    static /* synthetic */ Class class$org$eclipse$cdt$core$model$ICElement;

    public void dispose() {
        super.dispose();
        CoreModel.getDefault();
        CoreModel.removeElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (StructuredViewer)viewer;
        if (oldInput == null && newInput != null) {
            if (newInput instanceof ICRoot) {
                CoreModel.getDefault();
                CoreModel.addElementChangedListener((IElementChangedListener)this);
            }
        } else if (oldInput != null && newInput == null) {
            CoreModel.getDefault();
            CoreModel.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    public CContentProvider() {
    }

    public CContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            CUIPlugin.getDefault();
            CUIPlugin.log(e);
            e.printStackTrace();
        }
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        ICFile cfile;
        Object parent;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(element);
        }
        if (kind == 2) {
            parent = this.getParent(element);
            this.postRemove(element);
            if (element instanceof ICFile && this.updateContainer(cfile = (ICFile)element)) {
                this.postRefresh(parent);
            }
        }
        if (kind == 1) {
            parent = this.getParent(element);
            this.postAdd(parent, element);
            if (element instanceof ICFile && this.updateContainer(cfile = (ICFile)element)) {
                this.postRefresh(parent);
            }
        }
        if (kind == 4) {
            if ((flags & 0x800) != 0) {
                this.postRefresh(element.getCProject());
                return;
            }
            if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive) {
                this.postRefresh(element);
                return;
            }
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private void updateContainer(ICRoot root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    IStructuredSelection s = (IStructuredSelection)CContentProvider.this.fViewer.getSelection();
                    if (s.isEmpty()) {
                        return;
                    }
                    Object element = s.getFirstElement();
                    if (element instanceof ICProject) {
                        CContentProvider.this.updateContainer((ICProject)element);
                    }
                }
            }
        });
    }

    protected boolean updateContainer(ICProject cproject) {
        IBinaryContainer binContainer = cproject.getBinaryContainer();
        IArchiveContainer libContainer = cproject.getArchiveContainer();
        if (binContainer != null) {
            this.postContainerRefresh((IParent)binContainer, cproject);
        }
        if (libContainer != null) {
            this.postContainerRefresh((IParent)libContainer, cproject);
        }
        return false;
    }

    private boolean updateContainer(ICFile cfile) {
        IArchiveContainer container = null;
        ICProject cproject = null;
        if (cfile.isBinary()) {
            IBinary bin = (IBinary)cfile;
            if (bin.isExecutable() || bin.isSharedLib()) {
                cproject = bin.getCProject();
                container = cproject.getBinaryContainer();
            }
        } else if (cfile.isArchive()) {
            cproject = cfile.getCProject();
            container = cproject.getArchiveContainer();
        }
        if (container != null) {
            this.postContainerRefresh((IParent)container, cproject);
            return true;
        }
        return false;
    }

    private void postContainerRefresh(final IParent container, final ICProject cproject) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (container.hasChildren()) {
                        if (CContentProvider.this.fViewer.testFindItem((Object)container) != null) {
                            CContentProvider.this.fViewer.refresh((Object)container);
                        } else {
                            CContentProvider.this.fViewer.refresh((Object)cproject);
                        }
                    } else {
                        CContentProvider.this.fViewer.refresh((Object)cproject);
                    }
                }
            }
        });
    }

    private void postRefresh(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CContentProvider.this.fViewer.refresh(root);
                }
            }
        });
    }

    private void postAdd(final Object parent, Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CContentProvider.this.fViewer.refresh(parent);
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    CContentProvider.this.fViewer.refresh(CContentProvider.this.getParent(element));
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    protected ICElement getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (ICElement)((IAdaptable)o).getAdapter(class$org$eclipse$cdt$core$model$ICElement == null ? (class$org$eclipse$cdt$core$model$ICElement = CContentProvider.class$("org.eclipse.cdt.core.model.ICElement")) : class$org$eclipse$cdt$core$model$ICElement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

