/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.makeview;

import org.eclipse.cdt.internal.ui.makeview.MakeTarget;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class MakeContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected Viewer viewer;

    public Object[] getChildren(Object obj) {
        if (obj instanceof MakeTarget) {
            MakeTarget md = (MakeTarget)obj;
            return md.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object obj) {
        if (obj instanceof MakeTarget) {
            MakeTarget directives = (MakeTarget)obj;
            return directives.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object obj) {
        return this.getChildren(obj).length > 0;
    }

    public Object[] getElements(Object obj) {
        return this.getChildren(obj);
    }

    public void dispose() {
        Object obj;
        if (this.viewer != null && (obj = this.viewer.getInput()) instanceof MakeTarget) {
            MakeTarget target = (MakeTarget)obj;
            IWorkspace workspace = target.getResource().getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IWorkspace workspace;
        IResource res;
        this.viewer = viewer;
        if (oldInput != null && oldInput instanceof MakeTarget && (res = ((MakeTarget)oldInput).getResource()) instanceof IWorkspaceRoot) {
            workspace = res.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (newInput != null && newInput instanceof MakeTarget && (res = ((MakeTarget)newInput).getResource()) instanceof IWorkspaceRoot) {
            workspace = res.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final IResourceDelta deltas = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MakeContentProvider.this.processDelta(deltas);
                }
            });
        }
    }

    void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (delta == null) {
            return;
        }
        int changeFlags = delta.getFlags();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i = 0;
        while (i < affectedChildren.length) {
            if ((affectedChildren[i].getFlags() & 0x8000) != 0) {
                return;
            }
            ++i;
        }
        if ((changeFlags & 0x14000) != 0) {
            ctrl.setRedraw(false);
            this.viewer.refresh();
            ctrl.setRedraw(true);
            return;
        }
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            this.processDelta(affectedChildren[i2]);
            ++i2;
        }
        affectedChildren = delta.getAffectedChildren(3);
        if (affectedChildren.length > 0) {
            int i3 = 0;
            while (i3 < affectedChildren.length) {
                IResource r = affectedChildren[i3].getResource();
                if (r instanceof IContainer) {
                    ctrl.setRedraw(false);
                    this.viewer.refresh();
                    ctrl.setRedraw(true);
                    break;
                }
                ++i3;
            }
        }
    }
}

