/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTargetType;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IDummyStackFrame;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.model.IState;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDTDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private static CDTDebugModelPresentation fInstance = null;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICDebugTargetType;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IStackFrameInfo;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IDummyStackFrame;

    public CDTDebugModelPresentation() {
        fInstance = this;
    }

    public static CDTDebugModelPresentation getDefault() {
        return fInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value != null) {
            this.fAttributes.put(attribute, value);
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        IFile file = null;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            file = (IFile)resource;
        }
        if (element instanceof IFile) {
            file = (IFile)element;
        }
        if (element instanceof ICLineBreakpoint) {
            file = (IFile)((ICLineBreakpoint)element).getMarker().getResource().getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = CDTDebugModelPresentation.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        }
        if (file != null) {
            return new FileEditorInput(file);
        }
        if (element instanceof FileStorage) {
            return new ExternalEditorInput((IStorage)element);
        }
        if (element instanceof IDisassemblyStorage) {
            return new DisassemblyEditorInput((IStorage)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorRegistry registry;
        IEditorDescriptor descriptor;
        if (input != null && (descriptor = (registry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(input.getName())) != null) {
            return descriptor.getId();
        }
        return null;
    }

    public Image getImage(Object element) {
        int type;
        ICDebugTargetType targetType;
        if (element instanceof IDebugTarget) {
            targetType = (ICDebugTargetType)((IDebugTarget)element).getAdapter(class$org$eclipse$cdt$debug$core$model$ICDebugTargetType == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTargetType = CDTDebugModelPresentation.class$("org.eclipse.cdt.debug.core.model.ICDebugTargetType")) : class$org$eclipse$cdt$debug$core$model$ICDebugTargetType);
            int n = type = targetType != null ? targetType.getTargetType() : 0;
            if (type == 3) {
                return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"), 0));
            }
        }
        if (element instanceof IThread) {
            targetType = (ICDebugTargetType)((IThread)element).getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$ICDebugTargetType == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTargetType = CDTDebugModelPresentation.class$("org.eclipse.cdt.debug.core.model.ICDebugTargetType")) : class$org$eclipse$cdt$debug$core$model$ICDebugTargetType);
            int n = type = targetType != null ? targetType.getTargetType() : 0;
            if (type == 3) {
                return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"), 0));
            }
        }
        try {
            IBreakpoint bp;
            if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)bp);
            }
            if (element instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)element);
            }
            if (element instanceof IRegisterGroup) {
                return this.getRegisterGroupImage((IRegisterGroup)element);
            }
            if (element instanceof IExpression) {
                return this.getExpressionImage((IExpression)element);
            }
            if (element instanceof IRegister) {
                return this.getRegisterImage((IRegister)element);
            }
            if (element instanceof IVariable) {
                return this.getVariableImage((IVariable)element);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        boolean showQualified = this.isShowQualifiedNames();
        StringBuffer label = new StringBuffer();
        try {
            if (element instanceof IRegisterGroup) {
                label.append(((IRegisterGroup)element).getName());
                return label.toString();
            }
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof IMarker) {
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
                if (breakpoint != null) {
                    return this.getBreakpointText(breakpoint, showQualified);
                }
                return null;
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element, showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, "<terminated>");
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, "<disconnected>");
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException e) {
            return "<not_responding>";
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return null;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.fAttributes.get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        if (target instanceof IState) {
            IState state = (IState)target;
            switch (state.getCurrentStateId()) {
                case 8: {
                    Object info = state.getCurrentStateInfo();
                    String label = target.getName() + " (Exited";
                    if (info != null && info instanceof ICDIExitInfo) {
                        label = label + ". Exit code = " + ((ICDIExitInfo)info).getCode();
                    }
                    return label + ")";
                }
                case 7: {
                    Object info = state.getCurrentStateInfo();
                    if (info != null && info instanceof ICDISignal) {
                        String label = target.getName() + MessageFormat.format(" (Signal ''{0}'' received. Meaning: {1})", ((ICDISignal)info).getName(), ((ICDISignal)info).getMeaning());
                        return label;
                    }
                    if (info != null && info instanceof ICDIWatchpointTrigger) {
                        String label = target.getName() + MessageFormat.format(" (Watchpoint triggered. Old value: ''{0}''. New value: ''{1}'')", ((ICDIWatchpointTrigger)info).getOldValue(), ((ICDIWatchpointTrigger)info).getNewValue());
                        return label;
                    }
                    if (info != null && info instanceof ICDIWatchpointScope) {
                        return target.getName() + " (Watchpoint is out of scope)";
                    }
                    if (info != null && info instanceof ICDIBreakpointHit) {
                        return target.getName() + " (Breakpoint hit)";
                    }
                    if (info != null && info instanceof ICDIErrorInfo) {
                        return MessageFormat.format("{0} (Error: {1})", target.getName(), ((ICDIErrorInfo)info).getMessage());
                    }
                    if (info == null || !(info instanceof ICDISession)) break;
                    return target.getName() + " (Suspended)";
                }
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        int type;
        ICDebugTargetType targetType = (ICDebugTargetType)thread.getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$ICDebugTargetType == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTargetType = CDTDebugModelPresentation.class$("org.eclipse.cdt.debug.core.model.ICDebugTargetType")) : class$org$eclipse$cdt$debug$core$model$ICDebugTargetType);
        int n = type = targetType != null ? targetType.getTargetType() : 0;
        if (type == 3) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}]", thread.getName());
        }
        if (thread.isTerminated()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Terminated)", thread.getName());
        }
        if (thread.isStepping()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Stepping)", thread.getName());
        }
        if (!thread.isSuspended()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Running)", thread.getName());
        }
        return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Suspended)", thread.getName());
    }

    protected String getStackFrameText(IStackFrame stackFrame, boolean qualified) throws DebugException {
        IStackFrameInfo info = (IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CDTDebugModelPresentation.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo);
        if (info != null) {
            Path path;
            String label = new String();
            label = label + info.getLevel() + " ";
            if (info.getFunction() != null) {
                label = label + info.getFunction() + "() ";
            }
            if (info.getFile() != null && !(path = new Path(info.getFile())).isEmpty()) {
                label = label + "at " + (qualified ? path.toOSString() : path.lastSegment()) + ":";
            }
            if (info.getFrameLineNumber() != 0) {
                label = label + info.getFrameLineNumber();
            }
            return label;
        }
        IDummyStackFrame dummy = (IDummyStackFrame)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IDummyStackFrame == null ? (class$org$eclipse$cdt$debug$core$model$IDummyStackFrame = CDTDebugModelPresentation.class$("org.eclipse.cdt.debug.core.model.IDummyStackFrame")) : class$org$eclipse$cdt$debug$core$model$IDummyStackFrame);
        if (dummy != null) {
            return stackFrame.getName();
        }
        return stackFrame.getName();
    }

    protected String getVariableText(IVariable var) throws DebugException {
        String label = new String();
        if (var != null) {
            if (this.isShowVariableTypeNames()) {
                label = label + var.getReferenceTypeName() + " ";
            }
            label = label + var.getName();
            IValue value = var.getValue();
            if (value != null && value.getValueString() != null) {
                if (value instanceof ICValue) {
                    switch (((ICValue)value).getType()) {
                        case 1: {
                            label = label + value.getValueString();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            label = label + "= " + value.getValueString();
                            break;
                        }
                    }
                } else {
                    label = label + "= " + value.getValueString();
                }
            }
        }
        return label;
    }

    public static String getFormattedString(String key, String arg) {
        return CDTDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    protected Image getBreakpointImage(ICBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointImage((ICWatchpoint)breakpoint);
        }
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((ICBreakpoint)breakpoint);
        CImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? new CImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags) : new CImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags);
        return this.fDebugImageRegistry.get((ImageDescriptor)descriptor);
    }

    protected Image getWatchpointImage(ICWatchpoint watchpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags((ICBreakpoint)watchpoint);
        CImageDescriptor descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? new CImageDescriptor(CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED, flags) : (!watchpoint.isReadType() && watchpoint.isWriteType() ? new CImageDescriptor(CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED, flags) : new CImageDescriptor(CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED, flags))) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? new CImageDescriptor(CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED, flags) : (!watchpoint.isReadType() && watchpoint.isWriteType() ? new CImageDescriptor(CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED, flags) : new CImageDescriptor(CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED, flags)));
        return this.fDebugImageRegistry.get((ImageDescriptor)descriptor);
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointText((ICLineBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICAddressBreakpoint) {
            return this.getAddressBreakpointText((ICAddressBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return this.getFunctionBreakpointText((ICFunctionBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return this.getWatchpointText((ICWatchpoint)breakpoint, qualified);
        }
        return "";
    }

    protected String getLineBreakpointText(ICLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)breakpoint, label, qualified);
        this.appendLineNumber(breakpoint, label);
        this.appendIgnoreCount((ICBreakpoint)breakpoint, label);
        this.appendCondition((ICBreakpoint)breakpoint, label);
        return label.toString();
    }

    protected String getWatchpointText(ICWatchpoint watchpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        this.appendResourceName((ICBreakpoint)watchpoint, label, qualified);
        this.appendWatchExpression(watchpoint, label);
        this.appendIgnoreCount((ICBreakpoint)watchpoint, label);
        this.appendCondition((ICBreakpoint)watchpoint, label);
        return label.toString();
    }

    protected String getAddressBreakpointText(ICAddressBreakpoint breakpoint, boolean qualified) throws CoreException {
        return null;
    }

    protected String getFunctionBreakpointText(ICFunctionBreakpoint breakpoint, boolean qualified) throws CoreException {
        return null;
    }

    protected StringBuffer appendResourceName(ICBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        IPath path = breakpoint.getMarker().getResource().getLocation();
        if (!path.isEmpty()) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected StringBuffer appendLineNumber(ICLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(" [");
            label.append("line:");
            label.append(' ');
            label.append(lineNumber);
            label.append(']');
        }
        return label;
    }

    protected StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(" [");
            label.append("ignore count:");
            label.append(' ');
            label.append(ignoreCount);
            label.append(']');
        }
        return label;
    }

    protected void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(" if ");
            buffer.append(condition);
        }
    }

    private void appendWatchExpression(ICWatchpoint watchpoint, StringBuffer label) throws CoreException {
        String expression = watchpoint.getExpression();
        if (expression != null && expression.length() > 0) {
            label.append(" at '");
            label.append(expression);
            label.append('\'');
        }
    }

    private int computeBreakpointAdornmentFlags(ICBreakpoint breakpoint) {
        int flags = 0;
        try {
            if (breakpoint.isEnabled()) {
                flags |= 0x20;
            }
            if (breakpoint.isInstalled()) {
                flags |= 4;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return flags;
    }

    protected Image getVariableImage(IVariable element) throws DebugException {
        IValue value;
        if (element != null && (value = element.getValue()) instanceof ICValue) {
            return this.getValueTypeImage((ICValue)value);
        }
        return null;
    }

    protected Image getValueTypeImage(ICValue element) {
        if (element != null) {
            if (element.getType() == 1 || element.getType() == 2 || element.getType() == 9) {
                return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE, 0));
            }
            if (element.getType() == 4) {
                return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_VARIABLE_POINTER, 0));
            }
            return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_VARIABLE_SIMPLE, 0));
        }
        return null;
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) throws DebugException {
        return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_REGISTER_GROUP, 0));
    }

    protected Image getRegisterImage(IRegister element) throws DebugException {
        return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(CDebugImages.DESC_OBJS_REGISTER, 0));
    }

    protected Image getExpressionImage(IExpression element) throws DebugException {
        return this.fDebugImageRegistry.get((ImageDescriptor)new CImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"), 0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

