/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class VariableFormatActionDelegate
implements IObjectActionDelegate {
    private int fFormat = 1;
    private ICVariable fVariable = null;

    public VariableFormatActionDelegate(int format) {
        this.fFormat = format;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getVariable() != null) {
            final MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        VariableFormatActionDelegate.this.doAction(VariableFormatActionDelegate.this.getVariable());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    CDebugUIPlugin.errorDialog("Unable to set format of variable.", (IStatus)ms);
                } else {
                    CDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICVariable) {
            boolean enabled = this.enablesFor((ICVariable)element);
            action.setEnabled(enabled);
            if (enabled) {
                action.setChecked(((ICVariable)element).getFormat() == this.fFormat);
                this.setVariable((ICVariable)element);
                return;
            }
        }
        action.setChecked(false);
        action.setEnabled(false);
        this.setVariable(null);
    }

    private boolean enablesFor(ICVariable var) {
        boolean enabled = false;
        try {
            IValue value = var.getValue();
            if (value != null && value instanceof ICValue) {
                switch (((ICValue)value).getType()) {
                    case 0: 
                    case 4: 
                    case 8: {
                        enabled = true;
                    }
                }
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return enabled;
    }

    private void setVariable(ICVariable var) {
        this.fVariable = var;
    }

    protected ICVariable getVariable() {
        return this.fVariable;
    }

    protected void doAction(ICVariable var) throws DebugException {
        var.setFormat(this.fFormat);
        var.refresh();
    }
}

