/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class DebugTextHover
implements ITextHover {
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            return null;
        }
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (launchManager == null) {
            return null;
        }
        IDebugTarget[] targets = launchManager.getDebugTargets();
        if (targets != null && targets.length > 0) {
            try {
                IDocument document = textViewer.getDocument();
                if (document == null) {
                    return null;
                }
                String expression = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                if (expression == null) {
                    return null;
                }
                if ((expression = expression.trim()).length() == 0) {
                    return null;
                }
                ArrayList<IDebugTarget> targetList = new ArrayList<IDebugTarget>(targets.length);
                int i = 0;
                while (i < targets.length) {
                    ICExpressionEvaluator ee = (ICExpressionEvaluator)targets[i].getAdapter(class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator == null ? DebugTextHover.class$("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator") : class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator);
                    if (ee != null) {
                        targetList.add(i, targets[i]);
                    }
                    ++i;
                }
                StringBuffer buffer = new StringBuffer();
                boolean showDebugTarget = targetList.size() > 1;
                Iterator iterator = targetList.iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    IDebugTarget target = (IDebugTarget)iterator.next();
                    ICExpressionEvaluator ee = (ICExpressionEvaluator)target.getAdapter(class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator == null ? DebugTextHover.class$("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator") : class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator);
                    if (!ee.canEvaluate()) continue;
                    String result = this.evaluateExpression(ee, expression);
                    try {
                        if (result == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            buffer.append('\n');
                        }
                        if (showDebugTarget) {
                            buffer.append('[');
                            buffer.append(target.getName());
                            buffer.append("]: ");
                        }
                        buffer.append(expression);
                        buffer.append('=');
                        buffer.append(result);
                    }
                    catch (DebugException x) {
                        CDebugUIPlugin.log(x);
                    }
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
            return new Region(selectedRange.x, selectedRange.y);
        }
        if (viewer != null) {
            return CDebugUIUtils.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    private String evaluateExpression(ICExpressionEvaluator ee, String expression) {
        String result = null;
        try {
            result = ee.evaluateExpressionToString(expression);
        }
        catch (DebugException e) {
            // empty catch block
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

