/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import java.io.File;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationBlock;
import org.eclipse.cdt.debug.ui.sourcelookup.INewSourceLocationWizard;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AddDirectorySourceLocationWizard
extends Wizard
implements INewSourceLocationWizard {
    protected static final String PAGE_NAME = "AddDirectorySourceLocationWizardPage";
    protected IDirectorySourceLocation fSourceLocation = null;
    private IPath fInitialAssociationPath = null;

    public AddDirectorySourceLocationWizard() {
    }

    public AddDirectorySourceLocationWizard(IPath initialAssociationPath) {
        this.fInitialAssociationPath = initialAssociationPath;
    }

    public boolean performFinish() {
        AddDirtectorySourceLocationWizardPage page = (AddDirtectorySourceLocationWizardPage)this.getStartingPage();
        if (page != null) {
            return page.finish();
        }
        return false;
    }

    public String getDescription() {
        return "Add a local file system directory to the source locations list.";
    }

    public void addPages() {
        this.addPage((IWizardPage)new AddDirtectorySourceLocationWizardPage(this, this.fInitialAssociationPath));
    }

    public ICSourceLocation getSourceLocation() {
        return this.fSourceLocation;
    }

    public class AddDirtectorySourceLocationWizardPage
    extends WizardPage {
        private AddDirectorySourceLocationBlock fAttachBlock;

        public AddDirtectorySourceLocationWizardPage(AddDirectorySourceLocationWizard wizard, IPath initialAssociationPath) {
            super(AddDirectorySourceLocationWizard.PAGE_NAME, "Select Directory", CDebugImages.DESC_WIZBAN_ADD_DIR_SOURCE_LOCATION);
            AddDirectorySourceLocationWizard.this.setWindowTitle("Add Directory Source Location");
            this.setMessage("Add a local file system directory to the source locations list.");
            this.setWizard(wizard);
            this.fAttachBlock = new AddDirectorySourceLocationBlock(initialAssociationPath);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(768));
            this.fAttachBlock.createControl(composite);
            this.fAttachBlock.addDirectoryModifyListener(new ModifyListener(this){
                private final /* synthetic */ AddDirtectorySourceLocationWizardPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.directoryChanged();
                }
            });
            this.fAttachBlock.addAssociationModifyListener(new ModifyListener(this){
                private final /* synthetic */ AddDirtectorySourceLocationWizardPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.associationChanged();
                }
            });
            this.setControl((Control)composite);
            this.updateState();
        }

        protected void directoryChanged() {
            this.updateState();
        }

        protected void associationChanged() {
            this.updateState();
        }

        private void updateState() {
            boolean complete = true;
            this.setErrorMessage(null);
            String dirText = this.fAttachBlock.getLocationPath();
            if (dirText.length() == 0) {
                this.setErrorMessage("Directory must not be empty.");
                complete = false;
            } else {
                File file = new File(dirText);
                if (!file.exists() || !file.isDirectory()) {
                    this.setErrorMessage("Directory does not exist.");
                    complete = false;
                } else if (!file.isAbsolute()) {
                    this.setErrorMessage("Directory must be absolute.");
                    complete = false;
                }
            }
            this.setPageComplete(complete);
        }

        private IDirectorySourceLocation getSourceLocation() {
            return this.fAttachBlock.getSourceLocation();
        }

        protected boolean finish() {
            AddDirectorySourceLocationWizard.this.fSourceLocation = this.getSourceLocation();
            return AddDirectorySourceLocationWizard.this.fSourceLocation != null;
        }
    }
}

