/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttachSourceLocationBlock {
    private Composite fControl = null;
    private Text fLocationText = null;
    private Text fAssociationText = null;
    private Button fAssocitedCheckButton = null;
    private FontMetrics fFontMetrics;
    private Shell fShell = null;

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        this.fControl.setLayout((Layout)new GridLayout());
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.fControl);
        this.createLocationControls(this.fControl);
        this.createAssociationControls(this.fControl);
    }

    public void setInitialLocationPath(IPath path) {
        if (path != null) {
            this.fLocationText.setText(path.toOSString());
        }
    }

    public void setInitialAssociationPath(IPath path) {
        this.fAssociationText.setEnabled(path != null);
        this.fAssocitedCheckButton.setEnabled(path != null);
        this.fAssocitedCheckButton.setSelection(path != null);
        if (path != null) {
            this.fAssociationText.setText(path.toOSString());
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void createLocationControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Select location directory:");
        label.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)70);
        composite.setLayoutData((Object)data);
        this.fLocationText = new Text(composite, 2052);
        this.fLocationText.setLayoutData((Object)new GridData(768));
        Button button = this.createButton(composite, "&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachSourceLocationBlock.this.selectLocation();
            }
        });
    }

    protected void selectLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setMessage("Select Location Directory");
        String result = dialog.open();
        if (result != null) {
            this.fLocationText.setText(result);
        }
    }

    protected void createAssociationControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.fAssocitedCheckButton = new Button(composite, 32);
        this.fAssocitedCheckButton.setText("&Associate with");
        this.fAssociationText = new Text(composite, 2052);
        this.fAssociationText.setLayoutData((Object)new GridData(768));
        this.fAssocitedCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachSourceLocationBlock.this.associationSelectionChanged();
            }
        });
    }

    protected void associationSelectionChanged() {
        boolean checked = this.fAssocitedCheckButton.getSelection();
        this.fAssociationText.setEnabled(checked);
        if (!checked) {
            this.fAssociationText.setText("");
        }
    }

    protected Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(3);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    protected int convertVerticalDLUsToPixels(int dlus) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public String getLocationPath() {
        return this.fLocationText.getText().trim();
    }

    public String getAssociationPath() {
        if (this.fAssocitedCheckButton.getSelection()) {
            return this.fAssociationText.getText().trim();
        }
        return "";
    }
}

