/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.ui.sourcelookup.AttachSourceLocationBlock;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttachSourceLocationDialog
extends Dialog {
    private IPath fLocationPath = null;
    private IPath fAssociationPath = null;
    private AttachSourceLocationBlock fAttachBlock = new AttachSourceLocationBlock();

    public AttachSourceLocationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Attach Source Location");
        this.fAttachBlock.createControl(composite);
        this.fAttachBlock.setInitialAssociationPath(this.fAssociationPath);
        return composite;
    }

    public void setInitialPath(IPath path) {
        this.fAssociationPath = path;
    }

    protected void okPressed() {
        String locationString = this.fAttachBlock.getLocationPath();
        if (locationString.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)"Location directory is not selected");
            return;
        }
        if (!this.isLocationPathValid(locationString)) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)MessageFormat.format("Invalid path: ''{0}''", locationString));
            return;
        }
        String associationString = this.fAttachBlock.getAssociationPath();
        if (!this.isAssociationPathValid(associationString)) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)MessageFormat.format("Invalid path: ''{0}''", associationString));
            return;
        }
        this.fLocationPath = this.getLocation0();
        this.fAssociationPath = this.getAssociation0();
        super.okPressed();
    }

    public boolean isLocationPathValid(String pathString) {
        if (Path.EMPTY.isValidPath(pathString)) {
            Path path = new Path(pathString);
            return path.toFile().exists();
        }
        return false;
    }

    public boolean isAssociationPathValid(String pathString) {
        if (pathString.length() > 0) {
            return Path.EMPTY.isValidPath(pathString);
        }
        return true;
    }

    public IPath getLocation() {
        return this.fLocationPath;
    }

    private IPath getLocation0() {
        if (Path.EMPTY.isValidPath(this.fAttachBlock.getLocationPath())) {
            return new Path(this.fAttachBlock.getLocationPath());
        }
        return null;
    }

    public IPath getAssociation() {
        return this.fAssociationPath;
    }

    private IPath getAssociation0() {
        if (Path.EMPTY.isValidPath(this.fAttachBlock.getAssociationPath())) {
            return new Path(this.fAttachBlock.getAssociationPath());
        }
        return null;
    }
}

