/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICatchEvent;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDICatchpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakCondition;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakPoint;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends SessionObject
implements ICDIBreakpointManager {
    List breakList = new ArrayList(1);
    List delList = new ArrayList(1);
    boolean allowInterrupt = true;

    public BreakpointManager(CSession session) {
        super(session);
    }

    public MIBreakPoint[] getMIBreakpoints() throws CDIException {
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            s.getMISession().postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getBreakPoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    void update() throws CDIException {
        MIBreakPoint[] newMIBreakPoints = this.getMIBreakpoints();
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(newMIBreakPoints.length);
        int i = 0;
        while (i < newMIBreakPoints.length) {
            int no = newMIBreakPoints[i].getNumber();
            if (this.containsBreakpoint(no)) {
                if (this.hasBreakpointChanged(newMIBreakPoints[i])) {
                    eventList.add(new MIBreakPointChangedEvent(no));
                }
            } else {
                this.breakList.add(new Breakpoint(this, newMIBreakPoints[i]));
                eventList.add(new MIBreakPointCreatedEvent(no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = this.listBreakpoints();
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            int no = oldBreakpoints[i2].getMIBreakPoint().getNumber();
            int j = 0;
            while (j < newMIBreakPoints.length) {
                if (no == newMIBreakPoints[i2].getNumber()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.breakList.remove(oldBreakpoints[i2]);
                this.delList.add(oldBreakpoints[i2]);
                eventList.add(new MIBreakPointDeletedEvent(no));
            }
            ++i2;
        }
        MISession mi = this.getCSession().getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    boolean containsBreakpoint(int number) {
        return this.getBreakpoint(number) != null;
    }

    boolean hasBreakpointChanged(MIBreakPoint miBreakPoint) {
        return false;
    }

    Breakpoint getBreakpoint(int number) {
        Breakpoint[] bkpts = this.listBreakpoints();
        int i = 0;
        while (i < bkpts.length) {
            Breakpoint point;
            MIBreakPoint miBreak;
            if (bkpts[i] instanceof Breakpoint && (miBreak = (point = bkpts[i]).getMIBreakPoint()).getNumber() == number) {
                return point;
            }
            ++i;
        }
        return null;
    }

    Watchpoint getWatchpoint(int number) {
        return (Watchpoint)this.getBreakpoint(number);
    }

    Breakpoint[] listBreakpoints() {
        return this.breakList.toArray(new Breakpoint[this.breakList.size()]);
    }

    boolean suspendInferior() throws CDIException {
        boolean shouldRestart = false;
        CSession s = this.getCSession();
        CTarget target = s.getCTarget();
        if (target.isRunning() && this.allowInterrupt) {
            int lastToken = target.getLastExecutionToken();
            shouldRestart = true;
            ((EventManager)s.getEventManager()).disableEventToken(lastToken);
            target.suspend();
            ((EventManager)s.getEventManager()).enableEventToken(lastToken);
        }
        return shouldRestart;
    }

    void resumeInferior(boolean shouldRestart) throws CDIException {
        if (shouldRestart) {
            CSession s = this.getCSession();
            CTarget target = s.getCTarget();
            target.resume();
        }
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteAllBreakpoints() throws CDIException {
        this.deleteBreakpoints((ICDIBreakpoint[])this.listBreakpoints());
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints(new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        int[] numbers = new int[breakpoints.length];
        int i = 0;
        while (i < numbers.length) {
            if (!(breakpoints[i] instanceof Breakpoint) || !this.breakList.contains(breakpoints[i])) {
                throw new CDIException("Not a CDT breakpoint");
            }
            numbers[i] = ((Breakpoint)breakpoints[i]).getMIBreakPoint().getNumber();
            ++i;
        }
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            try {
                s.getMISession().postCommand(breakDelete);
                MIInfo info = breakDelete.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var10_10 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ArrayList<MIBreakPointDeletedEvent> eventList = new ArrayList<MIBreakPointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            this.breakList.remove(breakpoints[i2]);
            this.delList.add(breakpoints[i2]);
            int no = ((Breakpoint)breakpoints[i2]).getMIBreakPoint().getNumber();
            eventList.add(new MIBreakPointDeletedEvent(no));
            ++i2;
        }
        MISession mi = s.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    Breakpoint deleteBreakpoint(int no) {
        Breakpoint point = null;
        Breakpoint[] points = this.delList.toArray(new Breakpoint[this.delList.size()]);
        int i = 0;
        while (i < points.length) {
            if (points[i].getMIBreakPoint().getNumber() == no) {
                this.delList.remove(points[i]);
                point = points[i];
                break;
            }
            ++i;
        }
        return point;
    }

    public void enableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakPoint().getNumber();
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(new int[]{number});
        try {
            try {
                s.getMISession().postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var9_9 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ((Breakpoint)breakpoint).getMIBreakPoint().setEnabled(true);
    }

    public void disableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakPoint().getNumber();
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(new int[]{number});
        try {
            try {
                s.getMISession().postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var9_9 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ((Breakpoint)breakpoint).getMIBreakPoint().setEnabled(false);
    }

    public void setCondition(ICDIBreakpoint breakpoint, ICDICondition condition) throws CDIException {
        int ignoreCount;
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakPoint().getNumber();
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        String exprCond = condition.getExpression();
        if (exprCond == null) {
            exprCond = "";
        }
        if ((ignoreCount = condition.getIgnoreCount()) < 0) {
            ignoreCount = 0;
        }
        try {
            try {
                MIBreakCondition breakCondition = factory.createMIBreakCondition(number, exprCond);
                s.getMISession().postCommand(breakCondition);
                MIInfo info = breakCondition.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIBreakAfter breakAfter = factory.createMIBreakAfter(number, ignoreCount);
                s.getMISession().postCommand(breakAfter);
                info = breakAfter.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var13_13 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        this.update();
        return (ICDIBreakpoint[])this.listBreakpoints();
    }

    public ICDICatchpoint setCatchpoint(int type, ICDICatchEvent event, String expression, ICDICondition condition) throws CDIException {
        throw new CDIException("Not Supported");
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, String threadId) throws CDIException {
        boolean hardware = type == 2;
        boolean temporary = type == 1;
        String exprCond = null;
        int ignoreCount = 0;
        StringBuffer line = new StringBuffer();
        if (condition != null) {
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
        }
        if (location != null) {
            String file = location.getFile();
            String function = location.getFunction();
            if (file != null && file.length() > 0) {
                line.append(file).append(':');
                if (function != null && function.length() > 0) {
                    line.append(function);
                } else {
                    line.append(location.getLineNumber());
                }
            } else if (function != null && function.length() > 0) {
                line.append(function);
            } else if (location.getLineNumber() != 0) {
                line.append(location.getLineNumber());
            } else {
                line.append('*').append(location.getAddress());
            }
        }
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakInsert breakInsert = factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString());
        MIBreakPoint[] points = null;
        try {
            try {
                s.getMISession().postCommand(breakInsert);
                MIBreakInsertInfo info = breakInsert.getMIBreakInsertInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                points = info.getBreakPoints();
                if (points == null || points.length == 0) {
                    throw new CDIException("Error parsing");
                }
                Object var17_18 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        Breakpoint bkpt = new Breakpoint(this, points[0]);
        this.breakList.add(bkpt);
        return bkpt;
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        boolean access = (watchType & 1) == 1 && (watchType & 2) == 2;
        boolean read = (watchType & 1) != 1 && (watchType & 2) == 2;
        boolean state = this.suspendInferior();
        CSession s = this.getCSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakPoint[] points = null;
        try {
            try {
                s.getMISession().postCommand(breakWatch);
                MIBreakWatchInfo info = breakWatch.getMIBreakWatchInfo();
                points = info.getBreakPoints();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                if (points == null || points.length == 0) {
                    throw new CDIException("Parsing Error");
                }
                Object var14_14 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        Watchpoint bkpt = new Watchpoint(this, points[0]);
        this.breakList.add(bkpt);
        return bkpt;
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return new Condition(ignoreCount, expression);
    }

    public ICDILocation createLocation(String file, String function, int line) {
        return new Location(file, function, line);
    }

    public ICDILocation createLocation(long address) {
        return new Location(address);
    }
}

