/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.StackFrame;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListFramesInfo;

public class CThread
extends CObject
implements ICDIThread {
    int id;
    static StackFrame[] noStack = new StackFrame[0];
    StackFrame currentFrame;

    public CThread(CTarget target, int threadId) {
        super(target);
        this.id = threadId;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    StackFrame getCurrentStackFrame() throws CDIException {
        ICDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    public ICDIStackFrame[] getStackFrames() throws CDIException {
        ICDIStackFrame[] stack = noStack;
        CSession session = this.getCTarget().getCSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIStackListFrames frames = factory.createMIStackListFrames();
        try {
            ICDIThread oldThread = this.getCTarget().getCurrentThread();
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(frames);
            MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIFrame[] miFrames = info.getMIFrames();
            stack = new StackFrame[miFrames.length];
            int i = 0;
            while (i < stack.length) {
                stack[i] = new StackFrame(this, miFrames[i]);
                ++i;
            }
            this.getCTarget().setCurrentThread(oldThread);
            return stack;
        }
        catch (MIException e) {
        }
        catch (CDIException e) {
            // empty catch block
        }
        return stack;
    }

    public int getStackFrameCount() throws CDIException {
        CSession session = this.getCTarget().getCSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIStackInfoDepth depth = factory.createMIStackInfoDepth();
        try {
            ICDIThread oldThread = this.getCTarget().getCurrentThread();
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(depth);
            MIStackInfoDepthInfo info = depth.getMIStackInfoDepthInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            this.getCTarget().setCurrentThread(oldThread);
            return info.getDepth();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIStackFrame[] getStackFrames(int low, int high) throws CDIException {
        ICDIStackFrame[] stack = noStack;
        CSession session = this.getCTarget().getCSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIStackListFrames frames = factory.createMIStackListFrames(low, high);
        try {
            ICDIThread oldThread = this.getCTarget().getCurrentThread();
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(frames);
            MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIFrame[] miFrames = info.getMIFrames();
            stack = new StackFrame[miFrames.length];
            int i = 0;
            while (i < stack.length) {
                stack[i] = new StackFrame(this, miFrames[i]);
                ++i;
            }
            this.getCTarget().setCurrentThread(oldThread);
            return stack;
        }
        catch (MIException e) {
        }
        catch (CDIException e) {
            // empty catch block
        }
        return stack;
    }

    public void setCurrentStackFrame(ICDIStackFrame stackframe) throws CDIException {
        if (stackframe instanceof StackFrame) {
            this.setCurrentStackFrame((StackFrame)stackframe);
        }
    }

    public void setCurrentStackFrame(StackFrame stackframe) throws CDIException {
        StackFrame current;
        CSession session = this.getCTarget().getCSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int frameNum = 0;
        if (stackframe != null) {
            frameNum = stackframe.getLevel();
        }
        if ((current = this.getCurrentStackFrame()) != null && current.getLevel() == frameNum) {
            return;
        }
        MIStackSelectFrame frame = factory.createMIStackSelectFrame(frameNum);
        try {
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(frame);
            MIInfo info = frame.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            this.currentFrame = stackframe;
            RegisterManager regMgr = session.getRegisterManager();
            regMgr.update();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void finish() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().finish();
    }

    public void resume() throws CDIException {
        this.getTarget().resume();
    }

    public void stepInto() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepInto();
    }

    public void stepIntoInstruction() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepIntoInstruction();
    }

    public void stepOver() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepOver();
    }

    public void stepOverInstruction() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepOverInstruction();
    }

    public void stepReturn() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepReturn();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().runUntil(location);
    }

    public void suspend() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().suspend();
    }

    public boolean equals(ICDIThread thread) {
        if (thread instanceof CThread) {
            CThread cthread = (CThread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }
}

