/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.cdi.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class DestroyedEvent
implements ICDIDestroyedEvent {
    CSession session;
    ICDIObject source;

    public DestroyedEvent(CSession s, MIThreadExitEvent ethread) {
        this.session = s;
        this.source = new CThread(this.session.getCTarget(), ethread.getId());
    }

    public DestroyedEvent(CSession s, MIVarChangedEvent var) {
        this.session = s;
        VariableManager mgr = this.session.getVariableManager();
        String varName = var.getVarName();
        VariableManager.Element element = mgr.removeOutOfScope(varName);
        this.source = element != null && element.variable != null ? element.variable : new CObject(this.session.getCTarget());
    }

    public DestroyedEvent(CSession s, MIBreakPointDeletedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.deleteBreakpoint(number);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCTarget());
    }

    public DestroyedEvent(CSession s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public DestroyedEvent(CSession s) {
        this.session = s;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

