/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.CreatedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.DisconnectedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MICreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));
    List tokenList = new ArrayList(1);

    public void update(Observable o, Object arg) {
        MIEvent miEvent = (MIEvent)arg;
        CSession session = this.getCSession();
        ArrayList<Object> cdiList = new ArrayList<Object>(1);
        if (!this.ignoreEventToken(miEvent.getToken())) {
            if (miEvent instanceof MIStoppedEvent) {
                this.processSuspendedEvent((MIStoppedEvent)miEvent);
                cdiList.add(new SuspendedEvent(session, miEvent));
            } else if (miEvent instanceof MIRunningEvent) {
                cdiList.add(new ResumedEvent(session, (MIRunningEvent)miEvent));
            } else if (miEvent instanceof MIChangedEvent) {
                if (miEvent instanceof MIVarChangedEvent) {
                    MIVarChangedEvent eventChanged = (MIVarChangedEvent)miEvent;
                    if (eventChanged.isInScope()) {
                        cdiList.add(new ChangedEvent(session, eventChanged));
                    } else {
                        cdiList.add(new DestroyedEvent(session, eventChanged));
                    }
                } else if (miEvent instanceof MIRegisterChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MIRegisterChangedEvent)miEvent));
                } else if (miEvent instanceof MIMemoryChangedEvent) {
                    MemoryManager mgr = (MemoryManager)session.getMemoryManager();
                    MemoryBlock[] blocks = mgr.listMemoryBlocks();
                    MIMemoryChangedEvent miMem = (MIMemoryChangedEvent)miEvent;
                    Long[] addresses = miMem.getAddresses();
                    int i = 0;
                    while (i < blocks.length) {
                        if (blocks[i].contains(addresses) && (!blocks[i].isFrozen() || blocks[i].isDirty())) {
                            cdiList.add(new MemoryChangedEvent(session, blocks[i], miMem));
                            blocks[i].setDirty(false);
                        }
                        ++i;
                    }
                } else if (miEvent instanceof MIBreakPointChangedEvent) {
                    MIBreakPointChangedEvent bpoint = (MIBreakPointChangedEvent)miEvent;
                    if (bpoint.getNumber() > 0) {
                        cdiList.add(new ChangedEvent(session, (MIBreakPointChangedEvent)miEvent));
                    } else {
                        try {
                            ((BreakpointManager)session.getBreakpointManager()).update();
                        }
                        catch (CDIException e) {}
                    }
                }
            } else if (miEvent instanceof MIDestroyedEvent) {
                if (miEvent instanceof MIThreadExitEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIThreadExitEvent)miEvent));
                } else if (miEvent instanceof MIInferiorExitEvent) {
                    cdiList.add(new ExitedEvent(session, (MIInferiorExitEvent)miEvent));
                } else if (miEvent instanceof MIGDBExitEvent) {
                    cdiList.add(new DestroyedEvent(session));
                } else if (miEvent instanceof MIDetachedEvent) {
                    cdiList.add(new DisconnectedEvent(session));
                } else if (miEvent instanceof MIBreakPointDeletedEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIBreakPointDeletedEvent)miEvent));
                }
            } else if (miEvent instanceof MICreatedEvent && miEvent instanceof MIBreakPointCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIBreakPointCreatedEvent)miEvent));
            }
        }
        ICDIEvent[] cdiEvents = cdiList.toArray(new ICDIEvent[0]);
        this.fireEvents(cdiEvents);
    }

    public EventManager(CSession session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(ICDIEventListener listener) {
        this.list.remove(listener);
    }

    private void fireEvents(ICDIEvent[] cdiEvents) {
        if (cdiEvents != null) {
            int i = 0;
            while (i < cdiEvents.length) {
                this.fireEvent(cdiEvents[i]);
                ++i;
            }
        }
    }

    private void fireEvent(ICDIEvent cdiEvent) {
        if (cdiEvent != null) {
            ICDIEventListener[] listeners = this.list.toArray(new ICDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvent(cdiEvent);
                ++i;
            }
        }
    }

    void processSuspendedEvent(MIStoppedEvent stopped) {
        CTarget target = this.getCSession().getCTarget();
        int threadId = stopped.getThreadId();
        target.updateState(threadId);
        VariableManager varMgr = this.getCSession().getVariableManager();
        RegisterManager regMgr = this.getCSession().getRegisterManager();
        MemoryManager memMgr = (MemoryManager)this.getCSession().getMemoryManager();
        try {
            varMgr.update();
            regMgr.update();
            memMgr.update();
        }
        catch (CDIException e) {
            // empty catch block
        }
    }

    void processRunningEvent() {
    }

    void disableEventToken(int token) {
        this.tokenList.add(new Integer(token));
    }

    void disableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.disableEventToken(tokens[i]);
            ++i;
        }
    }

    void enableEventToken(int token) {
        Integer t = new Integer(token);
        if (this.tokenList.contains(t)) {
            this.tokenList.remove(t);
        }
    }

    void enableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.enableEventToken(tokens[i]);
            ++i;
        }
    }

    private boolean ignoreEventToken(int token) {
        return this.tokenList.contains(new Integer(token));
    }
}

